/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonPrimitive;
import java.util.Objects;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.raw.ModelLoadContext;
import kr.toxicity.model.api.util.function.Float2FloatConstantFunction;
import kr.toxicity.model.api.util.function.Float2FloatFunction;
import kr.toxicity.model.api.util.function.FloatFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Internal
public record ModelDatapoint(@Nullable JsonPrimitive x, @Nullable JsonPrimitive y, @Nullable JsonPrimitive z, @Nullable String script) {
    @Nullable
    private final String script;

    public boolean hasScript() {
        return this.script != null;
    }

    @NotNull
    public String script() {
        return Objects.requireNonNull(this.script);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public FloatFunction<Vector3f> toFunction(@NotNull ModelLoadContext context) {
        float xc;
        float f2;
        Float2FloatFunction xb = ModelDatapoint.build(this.x, context);
        Float2FloatFunction yb = ModelDatapoint.build(this.y, context);
        Float2FloatFunction zb = ModelDatapoint.build(this.z, context);
        if (!(xb instanceof Float2FloatConstantFunction)) return f -> new Vector3f(xb.applyAsFloat(f), yb.applyAsFloat(f), zb.applyAsFloat(f));
        Float2FloatConstantFunction float2FloatConstantFunction = (Float2FloatConstantFunction)xb;
        try {
            xc = f2 = float2FloatConstantFunction.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(yb instanceof Float2FloatConstantFunction)) return f -> new Vector3f(xb.applyAsFloat(f), yb.applyAsFloat(f), zb.applyAsFloat(f));
        Float2FloatConstantFunction float2FloatConstantFunction2 = (Float2FloatConstantFunction)yb;
        float yc = f2 = float2FloatConstantFunction2.value();
        if (!(zb instanceof Float2FloatConstantFunction)) return f -> new Vector3f(xb.applyAsFloat(f), yb.applyAsFloat(f), zb.applyAsFloat(f));
        Float2FloatConstantFunction float2FloatConstantFunction3 = (Float2FloatConstantFunction)zb;
        float zc = f2 = float2FloatConstantFunction3.value();
        return FloatFunction.of(new Vector3f(xc, yc, zc));
    }

    @NotNull
    private static Float2FloatFunction build(@Nullable JsonPrimitive primitive, @NotNull ModelLoadContext context) {
        if (primitive == null) {
            return Float2FloatFunction.ZERO;
        }
        if (primitive.isNumber()) {
            return Float2FloatFunction.of(primitive.getAsFloat());
        }
        String string = primitive.getAsString().trim();
        if (string.isEmpty()) {
            return Float2FloatFunction.ZERO;
        }
        try {
            return Float2FloatFunction.of(Float.parseFloat(string));
        }
        catch (NumberFormatException ignored) {
            return context.trySupply(() -> BetterModel.platform().evaluator().compile(context.placeholder.parseVariable(string)), error -> new ModelLoadContext.Fallback<Float2FloatConstantFunction>(Float2FloatFunction.ZERO, "Cannot parse this datapoint: " + String.valueOf(primitive) + ", reason: " + error.getMessage()));
        }
    }
}

