/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.library.dynamicuv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class UVUtil {
    static final BufferedImage NORMAL_PIXEL = new BufferedImage(16, 16, 1);
    static final BufferedImage TRANSLUCENT_PIXEL = new BufferedImage(16, 16, 2);

    private UVUtil() {
        throw new RuntimeException();
    }

    public static int rgb(int value) {
        return value & 0xFFFFFF;
    }

    public static int alpha(int value) {
        return value >> 24 & 0xFF;
    }

    @NotNull
    public static JsonObject packModel(@NotNull String textureName, @NotNull JsonArray elements) {
        JsonObject obj = new JsonObject();
        JsonObject textures = new JsonObject();
        textures.addProperty("0", textureName);
        textures.addProperty("particle", textureName);
        obj.add("textures", (JsonElement)textures);
        obj.add("elements", (JsonElement)elements);
        return obj;
    }

    static {
        Arrays.fill(((DataBufferInt)NORMAL_PIXEL.getRaster().getDataBuffer()).getData(), 0xFFFFFF);
        Arrays.fill(((DataBufferInt)TRANSLUCENT_PIXEL.getRaster().getDataBuffer()).getData(), -2130706433);
    }
}

