/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.library.dynamicuv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kr.toxicity.library.dynamicuv.UVByteBuilder;
import kr.toxicity.library.dynamicuv.UVElement;
import kr.toxicity.library.dynamicuv.UVIndexFunction;
import kr.toxicity.library.dynamicuv.UVIndexer;
import kr.toxicity.library.dynamicuv.UVLoadContext;
import kr.toxicity.library.dynamicuv.UVModelData;
import kr.toxicity.library.dynamicuv.UVNamespace;
import kr.toxicity.library.dynamicuv.UVTextureName;
import kr.toxicity.library.dynamicuv.UVUtil;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UVModel {
    @NotNull
    private final Supplier<UVNamespace> namespace;
    @NotNull
    private final String modelName;
    private final List<UVElement> elements = new ArrayList<UVElement>();
    @Nullable
    private String packName;

    public UVModel(@NotNull UVNamespace namespace, @NotNull String modelName) {
        this(() -> namespace, modelName);
    }

    @NotNull
    public UVModel addElement(@NotNull UVElement element) {
        this.elements.add(element);
        return this;
    }

    @NotNull
    public String itemModelNamespace() {
        return this.namespace.get().asset(this.packName());
    }

    @NotNull
    public String modelName() {
        return this.modelName;
    }

    @NotNull
    public String packName() {
        return this.packName != null ? this.packName : this.modelName;
    }

    public void packName(@Nullable String packName) {
        this.packName = packName;
    }

    @NotNull
    public List<UVByteBuilder> asJson() {
        return this.asJson(UVTextureName.DEFAULT);
    }

    @NotNull
    public List<UVByteBuilder> asJson(@NotNull UVTextureName textureName) {
        return this.asJson(textureName, i2 -> this.modelName + "_" + i2);
    }

    @NotNull
    public List<UVByteBuilder> asJson(@NotNull UVTextureName textureName, @NotNull UVIndexFunction indexFunction) {
        return this.asJson(new UVLoadContext(textureName, indexFunction, (indexer, namespace1, jsonArray) -> {}));
    }

    @NotNull
    public List<UVByteBuilder> asJson(@NotNull UVLoadContext context) {
        BuildContext buildContext = new BuildContext(this.namespace.get(), context);
        for (UVElement element : this.elements) {
            element.buildJson(buildContext);
        }
        JsonObject model2 = new JsonObject();
        model2.addProperty("type", "minecraft:composite");
        model2.add("models", (JsonElement)buildContext.composite);
        JsonObject obj = new JsonObject();
        obj.add("model", (JsonElement)model2);
        buildContext.builders.add(UVByteBuilder.of(buildContext.namespace.item(this.packName()), buildContext.builders.stream().mapToLong(UVByteBuilder::estimatedSize).sum(), (JsonElement)obj));
        return buildContext.builders;
    }

    @NotNull
    public UVModelData write(@NotNull BufferedImage image) {
        return this.write(image, builder -> {});
    }

    @NotNull
    public UVModelData write(@NotNull BufferedImage image, @NotNull Consumer<UVModelData.Builder> consumer) {
        UVModelData.Builder builder = UVModelData.builder();
        consumer.accept(builder);
        for (UVElement element : this.elements) {
            element.write(builder, image);
        }
        return builder.build();
    }

    @Generated
    public UVModel(@NotNull Supplier<UVNamespace> namespace, @NotNull String modelName) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        this.namespace = namespace;
        this.modelName = modelName;
    }

    static final class BuildContext {
        final UVNamespace namespace;
        final UVTextureName textureName;
        final UVIndexer indexer = new UVIndexer();
        private final UVIndexFunction indexFunction;
        private final List<UVByteBuilder> builders = new ArrayList<UVByteBuilder>();
        private final JsonArray composite = new JsonArray();

        BuildContext(@NotNull UVNamespace namespace, @NotNull UVLoadContext context) {
            this.namespace = namespace;
            this.indexFunction = context.indexFunction();
            this.textureName = namespace.toTextureAssets(context.textureName());
            context.buildFunction().build(this.indexer, namespace, this.composite);
        }

        @NotNull
        JsonObject newModel(@NotNull String texture, @NotNull JsonArray array) {
            String name = this.indexFunction.indexing(this.indexer.model());
            int elements = array.size();
            this.builders.add(UVByteBuilder.of(this.namespace.model(name), (long)elements * 256L, (JsonElement)UVUtil.packModel(texture, array)));
            return this.asModelJson(name, elements);
        }

        void addToComposite(@NotNull JsonObject object) {
            this.composite.add((JsonElement)object);
        }

        @NotNull
        private JsonObject asModelJson(@NotNull String name, int elements) {
            JsonObject obj = new JsonObject();
            obj.addProperty("type", "model");
            obj.addProperty("model", this.namespace.asset(name));
            JsonArray tints = new JsonArray(elements);
            for (int i2 = 0; i2 < elements; ++i2) {
                JsonObject tint = new JsonObject();
                tint.addProperty("type", "minecraft:custom_model_data");
                tint.addProperty("index", (Number)this.indexer.color());
                tint.addProperty("default", (Number)0);
                tints.add((JsonElement)tint);
            }
            obj.add("tints", (JsonElement)tints);
            return obj;
        }

        @Generated
        public BuildContext(UVNamespace namespace, UVTextureName textureName, UVIndexFunction indexFunction) {
            this.namespace = namespace;
            this.textureName = textureName;
            this.indexFunction = indexFunction;
        }
    }
}

