/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.library.dynamicuv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import kr.toxicity.library.dynamicuv.ElementVector;
import kr.toxicity.library.dynamicuv.UVFace;
import org.jetbrains.annotations.NotNull;

public record UVMappedFace(@NotNull UVFace face, @NotNull ElementVector position, @NotNull ElementVector pixel) {
    private static final JsonArray MAX_UV = new JsonArray(4);

    @NotNull
    static JsonArray compositedJson(@NotNull Collection<UVMappedFace> faces) {
        JsonArray array = new JsonArray(faces.size());
        int i2 = 0;
        for (UVMappedFace face : faces) {
            array.add((JsonElement)face.asJson(i2++));
        }
        return array;
    }

    @NotNull
    JsonArray asJson() {
        JsonArray elements = new JsonArray(1);
        elements.add((JsonElement)this.asJson(0));
        return elements;
    }

    @NotNull
    private JsonObject asJson(int index) {
        ElementVector next = this.position.plus(this.face.mapVector(this.pixel));
        JsonObject obj = new JsonObject();
        obj.add("from", (JsonElement)ElementVector.min(this.position, next).asJson());
        obj.add("to", (JsonElement)ElementVector.max(this.position, next).asJson());
        JsonObject faces = new JsonObject();
        JsonObject uv = new JsonObject();
        uv.add("uv", (JsonElement)MAX_UV);
        uv.addProperty("tintindex", (Number)index);
        uv.addProperty("texture", "#0");
        faces.add(this.face.uvName(), (JsonElement)uv);
        obj.add("faces", (JsonElement)faces);
        return obj;
    }

    static {
        MAX_UV.add((Number)0);
        MAX_UV.add((Number)0);
        MAX_UV.add((Number)16);
        MAX_UV.add((Number)16);
    }
}

