/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.library.dynamicuv;

import java.util.function.Consumer;
import java.util.function.Function;
import kr.toxicity.library.dynamicuv.ElementVector;
import kr.toxicity.library.dynamicuv.UVAxis;
import kr.toxicity.library.dynamicuv.UVElement;
import kr.toxicity.library.dynamicuv.UVMappedFace;
import kr.toxicity.library.dynamicuv.UVPos;
import kr.toxicity.library.dynamicuv.UVSpace;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public enum UVFace {
    NORTH("north", ElementVector::xy, UVSpace::posXY){

        @Override
        public void iterate(@NotNull UVElement element, @NotNull Consumer<UVMappedFace> face) {
            float minZ = Math.min(element.from().z(), element.to().z());
            ElementVector pixel = element.pixel().mul(-1.0f);
            UVAxis.XY.iterate(element.to(), element.space(), pixel, (x, y) -> face.accept(new UVMappedFace(this, new ElementVector(x, y, minZ), pixel)));
        }
    }
    ,
    SOUTH("south", ElementVector::xy, UVSpace::posXY){

        @Override
        public void iterate(@NotNull UVElement element, @NotNull Consumer<UVMappedFace> face) {
            float maxZ = Math.max(element.from().z(), element.to().z());
            ElementVector pixel = element.pixel().mul(1.0f, -1.0f, -1.0f);
            UVAxis.XY.iterate(new ElementVector(element.from().x(), element.to().y(), element.to().z()), element.space(), pixel, (x, y) -> face.accept(new UVMappedFace(this, new ElementVector(x, y, maxZ), pixel)));
        }
    }
    ,
    EAST("east", ElementVector::zy, UVSpace::posZY){

        @Override
        public void iterate(@NotNull UVElement element, @NotNull Consumer<UVMappedFace> face) {
            float maxX = Math.max(element.from().x(), element.to().x());
            ElementVector pixel = element.pixel().mul(-1.0f);
            UVAxis.ZY.iterate(element.to(), element.space(), pixel, (z, y) -> face.accept(new UVMappedFace(this, new ElementVector(maxX, y, z), pixel)));
        }
    }
    ,
    WEST("west", ElementVector::zy, UVSpace::posZY){

        @Override
        public void iterate(@NotNull UVElement element, @NotNull Consumer<UVMappedFace> face) {
            float minX = Math.min(element.from().x(), element.to().x());
            ElementVector pixel = element.pixel().mul(-1.0f, -1.0f, 1.0f);
            UVAxis.ZY.iterate(new ElementVector(element.to().x(), element.to().y(), element.from().z()), element.space(), pixel, (z, y) -> face.accept(new UVMappedFace(this, new ElementVector(minX, y, z), pixel)));
        }
    }
    ,
    UP("up", ElementVector::xz, UVSpace::posXZ){

        @Override
        public void iterate(@NotNull UVElement element, @NotNull Consumer<UVMappedFace> face) {
            float maxY = Math.max(element.from().y(), element.to().y());
            ElementVector pixel = element.pixel().mul(-1.0f);
            UVAxis.XZ.iterate(element.to(), element.space(), pixel, (x, z) -> face.accept(new UVMappedFace(this, new ElementVector(x, maxY, z), pixel)));
        }
    }
    ,
    DOWN("down", ElementVector::xz, UVSpace::posXZ){

        @Override
        public void iterate(@NotNull UVElement element, @NotNull Consumer<UVMappedFace> face) {
            float minY = Math.min(element.from().y(), element.to().y());
            ElementVector pixel = element.pixel().mul(-1.0f, 1.0f, -1.0f);
            UVAxis.XZ.iterate(new ElementVector(element.to().x(), element.from().y(), element.to().z()), element.space(), pixel, (x, z) -> face.accept(new UVMappedFace(this, new ElementVector(x, minY, z), pixel)));
        }
    };

    private final String uvName;
    private final Function<ElementVector, ElementVector> vectorMapper;
    private final Function<UVSpace, UVPos> posMapper;

    @NotNull
    public ElementVector mapVector(@NotNull ElementVector vector) {
        return this.vectorMapper.apply(vector);
    }

    @NotNull
    public UVPos posOf(@NotNull UVSpace space) {
        return this.posMapper.apply(space);
    }

    @NotNull
    public String uvName() {
        return this.uvName;
    }

    public abstract void iterate(@NotNull UVElement var1, @NotNull Consumer<UVMappedFace> var2);

    @Generated
    private UVFace(String uvName, Function<ElementVector, ElementVector> vectorMapper, Function<UVSpace, UVPos> posMapper) {
        this.uvName = uvName;
        this.vectorMapper = vectorMapper;
        this.posMapper = posMapper;
    }
}

