/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.library.dynamicuv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kr.toxicity.library.dynamicuv.ElementVector;
import kr.toxicity.library.dynamicuv.UVFace;
import kr.toxicity.library.dynamicuv.UVMappedFace;
import kr.toxicity.library.dynamicuv.UVModel;
import kr.toxicity.library.dynamicuv.UVModelData;
import kr.toxicity.library.dynamicuv.UVPos;
import kr.toxicity.library.dynamicuv.UVSpace;
import kr.toxicity.library.dynamicuv.UVUtil;
import org.jetbrains.annotations.NotNull;

public final class UVElement {
    private final Map<UVFace, UVPos> mappingPos;
    private final ElementVector from;
    private final ElementVector to;
    private final ElementVector pixel;
    private final UVSpace space;
    private final ColorType colorType;
    private final List<UVMappedFace> faces;

    public UVElement(@NotNull ElementVector scale2, @NotNull ElementVector position, @NotNull UVSpace space, @NotNull ColorType colorType, @NotNull Map<UVFace, UVPos> mappingPos) {
        ElementVector center = scale2.toModelLocation();
        this.space = space;
        this.mappingPos = new EnumMap<UVFace, UVPos>(mappingPos);
        this.colorType = colorType;
        ElementVector centerPos = position.toModelLocation().plus(ElementVector.CENTER);
        this.from = center.div(-2.0f).plus(centerPos);
        this.to = center.div(2.0f).plus(centerPos);
        this.pixel = center.div(space.x(), space.y(), space.z());
        ArrayList list = new ArrayList();
        for (UVFace value : this.mappingPos.keySet()) {
            value.iterate(this, list::add);
        }
        this.faces = Collections.unmodifiableList(list);
    }

    @NotNull
    public ColorType colorType() {
        return this.colorType;
    }

    @NotNull
    public ElementVector from() {
        return this.from;
    }

    @NotNull
    public List<UVMappedFace> faces() {
        return this.faces;
    }

    @NotNull
    public UVSpace space() {
        return this.space;
    }

    @NotNull
    public ElementVector pixel() {
        return this.pixel;
    }

    @NotNull
    public ElementVector to() {
        return this.to;
    }

    @NotNull
    public JsonObject asJson(@NotNull String textureName) {
        return UVUtil.packModel(textureName, UVMappedFace.compositedJson(this.faces));
    }

    void write(@NotNull UVModelData.Builder builder, @NotNull BufferedImage image) {
        for (Map.Entry<UVFace, UVPos> entry : this.mappingPos.entrySet()) {
            entry.getValue().iterate(entry.getKey().posOf(this.space), (x, z) -> this.colorType.buildModelData(builder, x < image.getWidth() && z < image.getHeight() ? image.getRGB(x, z) : 0));
        }
    }

    void buildJson(@NotNull UVModel.BuildContext context) {
        this.colorType.buildJson(context, this.faces);
    }

    public static enum ColorType {
        RGB{

            @Override
            void buildModelData( @NotNull UVModelData.Builder builder, int value) {
                builder.colors().add(UVUtil.rgb(value));
            }

            @Override
            void buildJson(@NotNull UVModel.BuildContext context, @NotNull List<UVMappedFace> faces) {
                context.addToComposite(context.newModel(context.textureName.normalPixel(), UVMappedFace.compositedJson(faces)));
            }
        }
        ,
        ARGB{

            @Override
            void buildModelData( @NotNull UVModelData.Builder builder, int value) {
                builder.colors().add(UVUtil.rgb(value));
                builder.flags().add(UVUtil.alpha(value) > 0);
            }

            @Override
            void buildJson(@NotNull UVModel.BuildContext context, @NotNull List<UVMappedFace> faces) {
                for (UVMappedFace face : faces) {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("type", "minecraft:condition");
                    obj.addProperty("property", "minecraft:custom_model_data");
                    obj.addProperty("index", (Number)context.indexer.flag());
                    obj.add("on_true", (JsonElement)context.newModel(context.textureName.normalPixel(), face.asJson()));
                    obj.add("on_false", (JsonElement)EMPTY);
                    context.addToComposite(obj);
                }
            }
        }
        ,
        COMPLEX_ARGB{

            @Override
            void buildModelData( @NotNull UVModelData.Builder builder, int value) {
                builder.colors().add(UVUtil.rgb(value));
                builder.floats().add((float)Math.round((float)UVUtil.alpha(value) / 255.0f * 2.0f));
            }

            @Override
            void buildJson(@NotNull UVModel.BuildContext context, @NotNull List<UVMappedFace> faces) {
                for (UVMappedFace face : faces) {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("type", "minecraft:range_dispatch");
                    obj.addProperty("property", "minecraft:custom_model_data");
                    obj.addProperty("index", (Number)context.indexer.floats());
                    obj.add("fallback", (JsonElement)EMPTY);
                    JsonArray entries = new JsonArray(2);
                    entries.add((JsonElement)3.entry(1, context.newModel(context.textureName.translucentPixel(), face.asJson())));
                    context.indexer.shiftColor(-1);
                    entries.add((JsonElement)3.entry(2, context.newModel(context.textureName.normalPixel(), face.asJson())));
                    obj.add("entries", (JsonElement)entries);
                    context.addToComposite(obj);
                }
            }

            @NotNull
            private static JsonObject entry(int threshold, @NotNull JsonObject model2) {
                JsonObject entry = new JsonObject();
                entry.addProperty("threshold", (Number)threshold);
                entry.add("model", (JsonElement)model2);
                return entry;
            }
        };

        private static final JsonObject EMPTY;

        abstract void buildModelData(@NotNull UVModelData.Builder var1, int var2);

        abstract void buildJson(@NotNull UVModel.BuildContext var1, @NotNull List<UVMappedFace> var2);

        static {
            EMPTY = new JsonObject();
            EMPTY.addProperty("type", "minecraft:empty");
        }
    }
}

