/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import java.util.List;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class InterpolationUtil {
    private static final float FRAME_HASH = 0.01f;
    private static final float FRAME_HASH_REVERT = 100.0f;

    private InterpolationUtil() {
        throw new RuntimeException();
    }

    @NotNull
    public static @Unmodifiable List<AnimationMovement> buildAnimation(@NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation2, @NotNull List<VectorPoint> scale2, boolean rotationGlobal, @NotNull FloatSortedSet points) {
        VectorPointBuilder pp = InterpolationUtil.interpolatorFor(position);
        VectorPointBuilder sp = InterpolationUtil.interpolatorFor(scale2);
        VectorPointBuilder rp = InterpolationUtil.interpolatorFor(rotation2);
        AnimationMovement[] array = new AnimationMovement[points.size()];
        float before = 0.0f;
        FloatBidirectionalIterator iterator = points.iterator();
        int i2 = 0;
        while (iterator.hasNext()) {
            float f = iterator.nextFloat();
            VectorResult pr = pp.build(f);
            VectorResult sr = sp.build(f);
            VectorResult rr = rp.build(f);
            array[i2++] = new AnimationMovement(InterpolationUtil.roundTime(f - before), FunctionUtil.takeIf(pr.vector, MathUtil::isNotZero), FunctionUtil.takeIf(sr.vector, MathUtil::isNotZero), FunctionUtil.takeIf(rr.vector, MathUtil::isNotZero), rotationGlobal, pr.skipInterpolation || sr.skipInterpolation || rr.skipInterpolation);
            before = f;
        }
        return List.of(array);
    }

    @NotNull
    public static VectorPointBuilder interpolatorFor(final @NotNull List<VectorPoint> vectors) {
        final VectorPoint last = vectors.isEmpty() ? VectorPoint.EMPTY : vectors.getLast();
        return vectors.size() < 2 ? f -> new VectorResult(last.vector(f)) : new VectorPointBuilder(){
            private VectorPoint p1 = VectorPoint.EMPTY;
            private VectorPoint p2 = (VectorPoint)vectors.getFirst();
            private int i = 0;
            private float t = this.p2.time();

            @Override
            @NotNull
            public VectorResult build(float nextFloat) {
                while (this.i < vectors.size() - 1 && this.t < nextFloat) {
                    this.p1 = this.p2;
                    this.p2 = (VectorPoint)vectors.get(++this.i);
                    this.t = this.p2.time();
                }
                if (nextFloat > last.time()) {
                    return new VectorResult(last.vector(nextFloat));
                }
                return nextFloat == this.t ? new VectorResult(this.p2.vector(), !this.p1.isContinuous()) : new VectorResult(this.p1.interpolator().interpolate(vectors, this.i, nextFloat));
            }
        };
    }

    public static float roundTime(float time) {
        return (float)((int)MathUtil.fma(time, 100.0f, 0.001f)) * 0.01f;
    }

    public static void insertLerpFrame(@NotNull FloatSortedSet frames) {
        InterpolationUtil.insertLerpFrame(frames, (float)BetterModel.config().lerpFrameTime() / 20.0f);
    }

    public static void insertLerpFrame(@NotNull FloatSortedSet frames, float frame) {
        if (frame <= 0.0f) {
            return;
        }
        float first = 0.0f;
        float second = 0.0f;
        FloatListIterator iterator = new FloatArrayList((FloatCollection)frames).iterator();
        while (iterator.hasNext()) {
            first = second;
            second = iterator.nextFloat();
            int max = (int)((second - first) / frame);
            for (int i2 = 0; i2 < max; ++i2) {
                float add = MathUtil.fma(frame, (float)(i2 + 1), first);
                if (second - add < frame + 0.001f) continue;
                frames.add(add);
            }
        }
    }

    public static float alpha(float p0, float p1, float alpha) {
        float div = p1 - p0;
        return div == 0.0f ? 0.0f : (alpha - p0) / div;
    }

    @NotNull
    public static Vector3f lerp(@NotNull Vector3f p0, @NotNull Vector3f p1, float alpha) {
        return InterpolationUtil.lerp(p0, p1, alpha, new Vector3f());
    }

    @NotNull
    public static Vector3f lerp(@NotNull Vector3f p0, @NotNull Vector3f p1, float alpha, @NotNull Vector3f dest) {
        dest.x = InterpolationUtil.lerp(p0.x, p1.x, alpha);
        dest.y = InterpolationUtil.lerp(p0.y, p1.y, alpha);
        dest.z = InterpolationUtil.lerp(p0.z, p1.z, alpha);
        return dest;
    }

    public static float lerp(float p0, float p1, float alpha) {
        return MathUtil.fma(p1 - p0, alpha, p0);
    }

    private static float cubicBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float tt = t * t;
        float uuu = uu * u;
        float utt = u * tt;
        float uut = uu * t;
        float ttt = tt * t;
        return MathUtil.fma(uuu, p0, MathUtil.fma(3.0f * uut, p1, MathUtil.fma(3.0f * utt, p2, ttt * p3)));
    }

    private static float derivativeBezier(float p1, float p2, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float ut = u * t;
        float tt = t * t;
        return MathUtil.fma(3.0f * uu, p1, MathUtil.fma(6.0f * ut, p2 - p1, 3.0f * tt * (1.0f - p2)));
    }

    private static float solveBezierTForTime(float time, float h1, float h2) {
        float t = 0.5f;
        int maxIterations = 20;
        for (int i2 = 0; i2 < maxIterations; ++i2) {
            float bezTime = InterpolationUtil.cubicBezier(0.0f, h1, h2, 1.0f, t);
            float derivative = InterpolationUtil.derivativeBezier(h1, h2, t);
            float error = bezTime - time;
            if (Math.abs(error) < 1.0E-5f) {
                return t;
            }
            if (derivative != 0.0f) {
                t -= error / derivative;
            }
            t = Math.clamp(t, 0.0f, 1.0f);
        }
        return t;
    }

    @NotNull
    public static Vector3f bezier(float alpha, @NotNull Vector3f start2, @NotNull Vector3f end, @NotNull Vector3f bezierRightTime, @NotNull Vector3f bezierRightValue, @NotNull Vector3f bezierLeftTime, @NotNull Vector3f bezierLeftValue) {
        Vector3f p1 = start2.add((Vector3fc)bezierRightValue, new Vector3f());
        Vector3f p2 = end.add((Vector3fc)bezierLeftValue, new Vector3f());
        return new Vector3f(InterpolationUtil.cubicBezier(start2.x, p1.x, p2.x, end.x, InterpolationUtil.solveBezierTForTime(alpha, bezierRightTime.x, 1.0f + bezierLeftTime.x)), InterpolationUtil.cubicBezier(start2.y, p1.y, p2.y, end.y, InterpolationUtil.solveBezierTForTime(alpha, bezierRightTime.y, 1.0f + bezierLeftTime.y)), InterpolationUtil.cubicBezier(start2.z, p1.z, p2.z, end.z, InterpolationUtil.solveBezierTForTime(alpha, bezierRightTime.z, 1.0f + bezierLeftTime.z)));
    }

    @NotNull
    public static Vector3f catmull_rom(@NotNull Vector3f p0, @NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return new Vector3f(MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.x, MathUtil.fma(3.0f, p1.x, MathUtil.fma(-3.0f, p2.x, p3.x))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.x, MathUtil.fma(-5.0f, p1.x, MathUtil.fma(4.0f, p2.x, -p3.x))), MathUtil.fma(t, -p0.x + p2.x, 2.0f * p1.x))), MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.y, MathUtil.fma(3.0f, p1.y, MathUtil.fma(-3.0f, p2.y, p3.y))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.y, MathUtil.fma(-5.0f, p1.y, MathUtil.fma(4.0f, p2.y, -p3.y))), MathUtil.fma(t, -p0.y + p2.y, 2.0f * p1.y))), MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.z, MathUtil.fma(3.0f, p1.z, MathUtil.fma(-3.0f, p2.z, p3.z))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.z, MathUtil.fma(-5.0f, p1.z, MathUtil.fma(4.0f, p2.z, -p3.z))), MathUtil.fma(t, -p0.z + p2.z, 2.0f * p1.z)))).mul(0.5f);
    }

    @FunctionalInterface
    public static interface VectorPointBuilder {
        @NotNull
        public VectorResult build(float var1);
    }

    public record VectorResult(@NotNull Vector3f vector, boolean skipInterpolation) {
        public VectorResult(@NotNull Vector3f vector) {
            this(vector, false);
        }
    }
}

