/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.script;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import kr.toxicity.model.api.script.TimeScript;
import kr.toxicity.model.api.tracker.Tracker;
import org.jetbrains.annotations.NotNull;

public interface AnimationScript
extends Consumer<Tracker> {
    public static final AnimationScript EMPTY = AnimationScript.of((Tracker s) -> {});

    @Override
    public void accept(@NotNull Tracker var1);

    public boolean isSync();

    @NotNull
    default public TimeScript time(float time) {
        return new TimeScript(time, this);
    }

    @NotNull
    public static AnimationScript of(@NotNull Consumer<Tracker> source) {
        return AnimationScript.of(false, source);
    }

    @NotNull
    public static AnimationScript of(final boolean isSync, final @NotNull Consumer<Tracker> source) {
        Objects.requireNonNull(source);
        return new AnimationScript(){

            @Override
            public boolean isSync() {
                return isSync;
            }

            @Override
            public void accept(@NotNull Tracker tracker) {
                source.accept(tracker);
            }
        };
    }

    @NotNull
    public static AnimationScript of(@NotNull List<AnimationScript> scriptList) {
        return switch (scriptList.size()) {
            case 0 -> EMPTY;
            case 1 -> scriptList.getFirst();
            default -> {
                boolean sync = false;
                Consumer<Tracker> consumer = trigger -> {};
                for (AnimationScript entityScript : scriptList) {
                    sync = sync || entityScript.isSync();
                    consumer = consumer.andThen(entityScript);
                }
                yield AnimationScript.of(sync, consumer);
            }
        };
    }
}

