/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record ModelBoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
    public static final ModelBoundingBox MIN = ModelBoundingBox.of(0.1, 0.1, 0.1);

    @NotNull
    public static ModelBoundingBox of(@NotNull Vector3d min, @NotNull Vector3d max) {
        return ModelBoundingBox.of(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    @NotNull
    public static ModelBoundingBox of(double x, double y, double z) {
        return ModelBoundingBox.of(-x / 2.0, -y / 2.0, -z / 2.0, x / 2.0, y / 2.0, z / 2.0);
    }

    @NotNull
    public static ModelBoundingBox of(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new ModelBoundingBox(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ), Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
    }

    public double x() {
        return this.maxX - this.minX;
    }

    public double y() {
        return this.maxY - this.minY;
    }

    public double centerY() {
        return (this.maxY + this.minY) / 2.0;
    }

    public double z() {
        return this.maxZ - this.minZ;
    }

    @NotNull
    public Vector3f centerPoint() {
        return new Vector3f((float)(this.minX + this.maxX), (float)(this.minY + this.maxY), (float)(this.minZ + this.maxZ)).div(2.0f);
    }

    @NotNull
    public ModelBoundingBox times(double scale2) {
        return ModelBoundingBox.of(this.minX * scale2, this.minY * scale2, this.minZ * scale2, this.maxX * scale2, this.maxY * scale2, this.maxZ * scale2);
    }

    @NotNull
    public ModelBoundingBox center() {
        Vector3f center = this.centerPoint();
        return ModelBoundingBox.of(this.minX - (double)center.x, this.minY - (double)center.y, this.minZ - (double)center.z, this.maxX - (double)center.x, this.maxY - (double)center.y, this.maxZ - (double)center.z);
    }

    @NotNull
    public ModelBoundingBox invert() {
        return ModelBoundingBox.of(-this.minX, this.minY, -this.minZ, -this.maxX, this.maxY, -this.maxZ);
    }

    @NotNull
    public ModelBoundingBox rotate(@NotNull Quaterniond quaterniond) {
        Vector3f centerVec = this.centerPoint();
        return ModelBoundingBox.of(this.min().sub((Vector3fc)centerVec).rotate((Quaterniondc)quaterniond).add((Vector3fc)centerVec), this.max().sub((Vector3fc)centerVec).rotate((Quaterniondc)quaterniond).add((Vector3fc)centerVec));
    }

    @NotNull
    public Vector3d min() {
        return new Vector3d(this.minX, this.minY, this.minZ);
    }

    @NotNull
    public Vector3d max() {
        return new Vector3d(this.maxX, this.maxY, this.maxZ);
    }

    public double lengthZX() {
        return Math.sqrt(Math.pow(this.x(), 2.0) + Math.pow(this.z(), 2.0));
    }

    public double length() {
        return Math.sqrt(Math.pow(this.x(), 2.0) + Math.pow(this.y(), 2.0) + Math.pow(this.z(), 2.0));
    }
}

