/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record BoneMovement(@NotNull Vector3f position, @NotNull Vector3f scale, @NotNull Quaternionf rotation, @NotNull Vector3f rawRotation) {
    public BoneMovement() {
        this(new Vector3f(), new Vector3f(), new Quaternionf(), new Vector3f());
    }

    @NotNull
    public BoneMovement plus(@NotNull AnimationMovement movement, @NotNull BoneMovement dest) {
        Vector3f pos = movement.position();
        Vector3f scl = movement.scale();
        Vector3f rot = movement.rotation();
        Vector3f destPos = this.position.get(dest.position);
        Vector3f destScl = this.scale.get(dest.scale);
        Quaternionf destRot = this.rotation.get(dest.rotation);
        Vector3f destRawRot = this.rawRotation.get(dest.rawRotation);
        if (pos != null) {
            destPos.add((Vector3fc)pos);
        }
        if (scl != null) {
            destScl.mul(scl.x + 1.0f, scl.y + 1.0f, scl.z + 1.0f);
        }
        if (rot != null) {
            MathUtil.toQuaternion(destRawRot.add((Vector3fc)rot), destRot);
        }
        return dest;
    }

    @NotNull
    public BoneMovement set(@NotNull BoneMovement movement) {
        this.position.set((Vector3fc)movement.position);
        this.scale.set((Vector3fc)movement.scale);
        this.rotation.set((Quaternionfc)movement.rotation);
        this.rawRotation.set((Vector3fc)movement.rawRotation);
        return this;
    }
}

