/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class AnimationEventHandler {
    private final AtomicBoolean isAnimationRemoved = new AtomicBoolean();
    private Runnable onAnimationRemove;

    @NotNull
    public static AnimationEventHandler start() {
        return new AnimationEventHandler();
    }

    @ApiStatus.Internal
    public void animationRemove() {
        if (this.onAnimationRemove == null) {
            return;
        }
        if (this.isAnimationRemoved.compareAndSet(false, true)) {
            this.onAnimationRemove.run();
        }
    }

    @NotNull
    public AnimationEventHandler onAnimationRemove(@NotNull Runnable runnable) {
        if (this.onAnimationRemove == null) {
            this.onAnimationRemove = runnable;
        } else {
            Runnable previous = this.onAnimationRemove;
            this.onAnimationRemove = () -> {
                previous.run();
                runnable.run();
            };
        }
        return this;
    }
}

