/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import kr.toxicity.model.api.animation.Timed;
import kr.toxicity.model.api.util.function.FloatFunction;
import kr.toxicity.model.api.util.interpolator.VectorInterpolator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public record VectorPoint(@NotNull FloatFunction<Vector3f> function, float time, @NotNull BezierConfig bezier, @NotNull VectorInterpolator interpolator) implements Timed
{
    private static final Vector3f ZERO = new Vector3f();
    public static final VectorPoint EMPTY = new VectorPoint(FloatFunction.of(ZERO), 0.0f, new BezierConfig(null, null, null, null), VectorInterpolator.LINEAR);

    @NotNull
    public Vector3f vector() {
        return this.vector(this.time);
    }

    @NotNull
    public Vector3f vector(float time) {
        return this.function.apply(time);
    }

    public boolean isContinuous() {
        return this.interpolator.isContinuous();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VectorPoint)) {
            return false;
        }
        VectorPoint that = (VectorPoint)o;
        return Float.compare(this.time, that.time) == 0;
    }

    @Override
    public int hashCode() {
        return Float.hashCode(this.time);
    }

    public record BezierConfig(@Nullable Vector3f leftTime, @Nullable Vector3f leftValue, @Nullable Vector3f rightTime, @Nullable Vector3f rightValue) {
        @Nullable
        private final Vector3f leftTime;
        @Nullable
        private final Vector3f leftValue;
        @Nullable
        private final Vector3f rightTime;
        @Nullable
        private final Vector3f rightValue;

        @NotNull
        public Vector3f leftTime() {
            return this.leftTime != null ? this.leftTime : ZERO;
        }

        @NotNull
        public Vector3f leftValue() {
            return this.leftValue != null ? this.leftValue : ZERO;
        }

        @NotNull
        public Vector3f rightTime() {
            return this.rightTime != null ? this.rightTime : ZERO;
        }

        @NotNull
        public Vector3f rightValue() {
            return this.rightValue != null ? this.rightValue : ZERO;
        }
    }
}

