/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.armormodel;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.imageio.ImageIO;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorByteBuilder;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorData;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorModelContext;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

final class ArmorNamespace {
    private final ArmorModelContext context;
    final String namespace;
    final Builder items;
    final Builder textures;
    final Builder models;

    ArmorNamespace(@NotNull ArmorModelContext context, @NotNull String namespace) {
        this.context = context;
        this.namespace = namespace;
        this.items = new Builder("assets/" + namespace + "/items/armor/");
        this.textures = new Builder("assets/" + namespace + "/textures/item/armor/");
        this.models = new Builder("assets/" + namespace + "/models/armor/");
    }

    final class Builder {
        private final String prefix;

        <T> void add(@NotNull String name, @NotNull T value, @NotNull Function<T, byte[]> function) {
            ArmorNamespace.this.context.builders.add(ArmorByteBuilder.ofOnce(this.prefix + name, value, function));
        }

        void add(@NotNull String name, @NotNull ArmorData data) {
            this.add(name, data, d -> d.toJson().getBytes(StandardCharsets.UTF_8));
        }

        void add(@NotNull String name, @NotNull BufferedImage image) {
            this.add(name, image, img -> {
                byte[] byArray;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)img, "png", buffer);
                    byArray = buffer.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                buffer.close();
                return byArray;
            });
        }

        @Generated
        public Builder(String prefix) {
            this.prefix = prefix;
        }
    }
}

