/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import com.google.gson.JsonObject;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.pack.PackObfuscator;
import kr.toxicity.model.api.util.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;

public record BlueprintTexture(@NotNull String name, byte[] image, int width, int height, int uvWidth, int uvHeight, boolean canBeRendered) {
    public boolean isAnimatedTexture() {
        if (this.uvWidth > 0 && this.uvHeight > 0) {
            float h = (float)this.height / (float)this.uvHeight;
            float w = (float)this.width / (float)this.uvWidth;
            return h > w;
        }
        return this.height > 0 && this.width > 0 && this.height / this.width > 1;
    }

    @NotNull
    public JsonObject toMcmeta() {
        return JsonObjectBuilder.builder().jsonObject("animation", animation -> {
            animation.property("interpolate", true);
            animation.property("frametime", BetterModel.config().animatedTextureFrameTime());
        }).build();
    }

    @NotNull
    public String packName(@NotNull PackObfuscator obfuscator) {
        return obfuscator.obfuscate(this.name());
    }

    @NotNull
    public String packNamespace(@NotNull PackObfuscator obfuscator) {
        return BetterModel.config().namespace() + ":item/" + this.packName(obfuscator);
    }

    public boolean hasUVSize() {
        return this.uvWidth > 0 && this.uvHeight > 0;
    }

    @NotNull
    public ModelResolution resolution(@NotNull ModelResolution resolution) {
        if (!this.hasUVSize()) {
            return resolution;
        }
        return resolution.width() == this.width && resolution.height() == this.height ? resolution : new ModelResolution(this.uvWidth, this.uvHeight);
    }
}

