/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.function;

import java.util.Objects;
import java.util.function.Predicate;
import kr.toxicity.model.api.bone.BoneTag;
import kr.toxicity.model.api.bone.RenderedBone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface BonePredicate
extends Predicate<RenderedBone> {
    public static final BonePredicate TRUE = BonePredicate.of(State.TRUE, b -> true);
    public static final BonePredicate FALSE = BonePredicate.of(State.FALSE, b -> false);

    @NotNull
    public static Builder name(@NotNull String name) {
        return b -> b.name().name().equalsIgnoreCase(name);
    }

    @NotNull
    public static Builder tag(BoneTag ... tags) {
        if (tags.length == 0) {
            throw new RuntimeException("tags cannot be empty.");
        }
        return b -> b.name().tagged(tags);
    }

    @Override
    public boolean test(@NotNull RenderedBone var1);

    @NotNull
    public BonePredicate and(@NotNull Predicate<? super RenderedBone> var1);

    @NotNull
    public BonePredicate or(@NotNull Predicate<? super RenderedBone> var1);

    @NotNull
    public BonePredicate negate();

    @NotNull
    public State applyAtChildren();

    @NotNull
    public static BonePredicate from(@NotNull Predicate<RenderedBone> predicate) {
        return BonePredicate.of(State.NOT_SET, predicate);
    }

    @NotNull
    public static BonePredicate of(@NotNull State applyAtChildren, @NotNull Predicate<RenderedBone> predicate) {
        Objects.requireNonNull(predicate, "predicate cannot be null.");
        return new Packed(applyAtChildren, predicate);
    }

    @ApiStatus.Internal
    @NotNull
    default public BonePredicate children(boolean parentSuccess) {
        BonePredicate bonePredicate;
        if (parentSuccess) {
            switch (this.applyAtChildren().ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    bonePredicate = TRUE;
                    break;
                }
                case 1: {
                    bonePredicate = FALSE;
                    break;
                }
                case 2: {
                    bonePredicate = this;
                    break;
                }
            }
        } else {
            bonePredicate = this;
        }
        return bonePredicate;
    }

    @FunctionalInterface
    public static interface Builder
    extends Predicate<RenderedBone> {
        @NotNull
        default public BonePredicate notSet() {
            return this.build(State.NOT_SET);
        }

        @NotNull
        default public BonePredicate withChildren() {
            return this.build(State.TRUE);
        }

        @NotNull
        default public BonePredicate withoutChildren() {
            return this.build(State.FALSE);
        }

        @NotNull
        default public BonePredicate build(@NotNull State state) {
            return BonePredicate.of(state, this);
        }

        @NotNull
        default public Builder and(@NotNull Predicate<? super RenderedBone> other) {
            return bone -> this.test(bone) && other.test((RenderedBone)bone);
        }

        @NotNull
        default public Builder or(@NotNull Predicate<? super RenderedBone> other) {
            return bone -> this.test(bone) || other.test((RenderedBone)bone);
        }

        @NotNull
        default public Builder negate() {
            return bone -> !this.test(bone);
        }
    }

    public static enum State {
        TRUE,
        FALSE,
        NOT_SET;

    }

    public record Packed(@NotNull State applyAtChildren, @NotNull Predicate<RenderedBone> predicate) implements BonePredicate
    {
        @Override
        public boolean test(@NotNull RenderedBone bone) {
            return this.predicate.test(bone);
        }

        @Override
        @NotNull
        public BonePredicate and(@NotNull Predicate<? super RenderedBone> other) {
            Objects.requireNonNull(other);
            return BonePredicate.of(this.applyAtChildren, t -> this.predicate.test((RenderedBone)t) && other.test((RenderedBone)t));
        }

        @Override
        @NotNull
        public BonePredicate or(@NotNull Predicate<? super RenderedBone> other) {
            Objects.requireNonNull(other);
            return BonePredicate.of(this.applyAtChildren, t -> this.predicate.test((RenderedBone)t) || other.test((RenderedBone)t));
        }

        @Override
        @NotNull
        public BonePredicate negate() {
            return BonePredicate.of(this.applyAtChildren, t -> !this.predicate.test((RenderedBone)t));
        }
    }
}

