/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.script;

import java.math.BigDecimal;
import java.util.Map;
import kr.toxicity.model.api.script.AnimationScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@FunctionalInterface
public interface ScriptBuilder {
    @NotNull
    public AnimationScript build(@NotNull ScriptData var1);

    public static interface ScriptMetaData {
        @NotNull
        public @Unmodifiable Map<String, String> toMap();

        @Nullable
        default public Boolean asBoolean(@NotNull String key) {
            String get = this.toMap().get(key);
            if (get == null) {
                return null;
            }
            return switch (get) {
                case "true" -> true;
                case "false" -> false;
                default -> null;
            };
        }

        @Nullable
        default public Number asNumber(@NotNull String key) {
            String get = this.toMap().get(key);
            if (get == null) {
                return null;
            }
            try {
                return new BigDecimal(get);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Nullable
        default public String asString(@NotNull String key) {
            return this.toMap().get(key);
        }
    }

    public record ScriptData(@Nullable String args, @NotNull ScriptMetaData metadata) {
    }
}

