/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.profile;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.profile.ModelProfileInfo;
import kr.toxicity.model.api.profile.ModelProfileSkin;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ModelProfile {
    public static final ModelProfile UNKNOWN = ModelProfile.of(ModelProfileInfo.UNKNOWN);

    @NotNull
    public static ModelProfile of(@NotNull ModelProfileInfo info) {
        return new Simple(info, ModelProfileSkin.EMPTY);
    }

    @NotNull
    public static ModelProfile of(@NotNull ModelProfileInfo info, @NotNull ModelProfileSkin skin) {
        return new Simple(info, skin);
    }

    @NotNull
    public static ModelProfile of(@NotNull Player player) {
        PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(player.getUniqueId());
        return channel != null ? channel.base().profile() : BetterModel.nms().profile(player);
    }

    @NotNull
    public static Uncompleted of(@NotNull OfflinePlayer offlinePlayer) {
        return BetterModel.plugin().profileManager().supplier().supply(offlinePlayer);
    }

    @NotNull
    public static Uncompleted of(@NotNull UUID uuid) {
        return ModelProfile.of(Bukkit.getOfflinePlayer((UUID)uuid));
    }

    @NotNull
    public ModelProfileInfo info();

    @NotNull
    public ModelProfileSkin skin();

    @NotNull
    default public Uncompleted asUncompleted() {
        return new Uncompleted(){

            @Override
            @NotNull
            public ModelProfileInfo info() {
                return ModelProfile.this.info();
            }

            @Override
            @NotNull
            public CompletableFuture<ModelProfile> complete() {
                return CompletableFuture.completedFuture(ModelProfile.this);
            }
        };
    }

    @Nullable
    default public Player player() {
        return Bukkit.getPlayer((UUID)this.info().id());
    }

    public record Simple(@NotNull ModelProfileInfo info, @NotNull ModelProfileSkin skin) implements ModelProfile
    {
    }

    public static interface Uncompleted {
        @NotNull
        public ModelProfileInfo info();

        @NotNull
        public CompletableFuture<ModelProfile> complete();

        @NotNull
        default public ModelProfile fallback() {
            return ModelProfile.of(this.info());
        }
    }
}

