/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.nms;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kr.toxicity.model.api.event.ModelDamageSource;
import kr.toxicity.model.api.nms.HitBox;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public interface HitBoxListener {
    public static final HitBoxListener EMPTY = HitBoxListener.builder().build();

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    default public Builder toBuilder() {
        return new Builder().sync(this::sync).damage(this::damage).remove(this::remove).mount(this::mount).dismount(this::dismount);
    }

    public void sync(@NotNull HitBox var1);

    public boolean damage(@NotNull HitBox var1, @NotNull ModelDamageSource var2, double var3);

    public void remove(@NotNull HitBox var1);

    public void mount(@NotNull HitBox var1, @NotNull Entity var2);

    public void dismount(@NotNull HitBox var1, @NotNull Entity var2);

    public static class Builder {
        private static final Consumer<HitBox> DEFAULT_SYNC = h -> {};
        private static final OnDamage DEFAULT_DAMAGE = (h, s, d) -> false;
        private static final Consumer<HitBox> DEFAULT_REMOVE = h -> {};
        private static final BiConsumer<HitBox, Entity> DEFAULT_MOUNT = (h, e) -> {};
        private static final BiConsumer<HitBox, Entity> DEFAULT_DISMOUNT = (h, e) -> {};
        private Consumer<HitBox> sync = DEFAULT_SYNC;
        private OnDamage damage = DEFAULT_DAMAGE;
        private Consumer<HitBox> remove = DEFAULT_REMOVE;
        private BiConsumer<HitBox, Entity> mount = DEFAULT_MOUNT;
        private BiConsumer<HitBox, Entity> dismount = DEFAULT_DISMOUNT;

        private Builder() {
        }

        @NotNull
        public Builder sync(@NotNull Consumer<HitBox> sync) {
            this.sync = this.sync == DEFAULT_SYNC ? sync : this.sync.andThen(sync);
            return this;
        }

        @NotNull
        public Builder damage(@NotNull OnDamage damage) {
            this.damage = this.damage == DEFAULT_DAMAGE ? damage : this.damage.andThen(damage);
            return this;
        }

        @NotNull
        public Builder remove(@NotNull Consumer<HitBox> remove) {
            this.remove = this.remove == DEFAULT_REMOVE ? remove : this.remove.andThen(remove);
            return this;
        }

        @NotNull
        public Builder mount(@NotNull BiConsumer<HitBox, Entity> mount) {
            this.mount = this.mount == DEFAULT_MOUNT ? mount : this.mount.andThen(mount);
            return this;
        }

        @NotNull
        public Builder dismount(@NotNull BiConsumer<HitBox, Entity> dismount) {
            this.dismount = this.dismount == DEFAULT_DISMOUNT ? dismount : this.dismount.andThen(dismount);
            return this;
        }

        @NotNull
        public HitBoxListener build() {
            return new HitBoxListener(){

                @Override
                public void sync(@NotNull HitBox hitBox) {
                    sync.accept(hitBox);
                }

                @Override
                public boolean damage(@NotNull HitBox hitBox, @NotNull ModelDamageSource source, double damage) {
                    return damage.event(hitBox, source, damage);
                }

                @Override
                public void remove(@NotNull HitBox hitBox) {
                    remove.accept(hitBox);
                }

                @Override
                public void mount(@NotNull HitBox hitBox, @NotNull Entity entity) {
                    mount.accept(hitBox, entity);
                }

                @Override
                public void dismount(@NotNull HitBox hitBox, @NotNull Entity entity) {
                    dismount.accept(hitBox, entity);
                }
            };
        }
    }

    public static interface OnDamage {
        public boolean event(@NotNull HitBox var1, @NotNull ModelDamageSource var2, double var3);

        @NotNull
        default public OnDamage andThen(@NotNull OnDamage other) {
            return (h, s, d) -> this.event(h, s, d) || other.event(h, s, d);
        }
    }
}

