/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.org.incendo.cloud.paper.parser;

import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.BukkitCaptionKeys;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.parser.NamespacedKeyParser;
import kr.toxicity.model.shaded.org.incendo.cloud.caption.CaptionVariable;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandContext;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandInput;
import kr.toxicity.model.shaded.org.incendo.cloud.exception.parsing.ParserException;
import kr.toxicity.model.shaded.org.incendo.cloud.paper.parser.RegistryEntryImpl;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ArgumentParseResult;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ArgumentParser;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.MappedArgumentParser;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ParserDescriptor;
import kr.toxicity.model.shaded.org.incendo.cloud.suggestion.Suggestion;
import kr.toxicity.model.shaded.org.incendo.cloud.suggestion.SuggestionProvider;
import org.apiguardian.api.API;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;

@API(status=API.Status.EXPERIMENTAL)
public final class RegistryEntryParser<C, E extends Keyed>
implements ArgumentParser<C, RegistryEntry<E>>,
SuggestionProvider<C>,
MappedArgumentParser<C, NamespacedKey, RegistryEntry<E>> {
    private final ParserDescriptor<C, NamespacedKey> keyParser = NamespacedKeyParser.namespacedKeyParser();
    private final RegistryKey<E> registryKey;

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C, E extends Keyed> @NonNull ParserDescriptor<C, RegistryEntry<E>> registryEntryParser(RegistryKey<E> registryKey, TypeToken<E> elementType) {
        return ParserDescriptor.of(new RegistryEntryParser<C, E>(registryKey), (TypeToken)TypeToken.get((Type)TypeFactory.parameterizedClass(RegistryEntry.class, (Type[])new Type[]{elementType.getType()})));
    }

    public RegistryEntryParser(RegistryKey<E> registryKey) {
        this.registryKey = registryKey;
    }

    public @NonNull ArgumentParseResult<RegistryEntry<@NonNull E>> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        return this.keyParser.parser().parse(commandContext, commandInput).flatMapSuccess(key -> {
            Registry registry = RegistryAccess.registryAccess().getRegistry(this.registryKey);
            Keyed value = registry.get(key);
            if (value == null) {
                return ArgumentParseResult.failure((Throwable)((Object)new ParseException(key.asString(), this.registryKey, commandContext)));
            }
            return ArgumentParseResult.success(RegistryEntryImpl.of(value, key));
        });
    }

    public @NonNull ArgumentParser<C, NamespacedKey> baseParser() {
        return this.keyParser.parser();
    }

    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        ArrayList completions = new ArrayList();
        Registry registry = RegistryAccess.registryAccess().getRegistry(this.registryKey);
        registry.stream().map(arg_0 -> ((Registry)registry).getKeyOrThrow(arg_0)).forEach(key -> {
            if (input.hasRemainingInput() && key.getNamespace().equals("minecraft")) {
                completions.add(Suggestion.suggestion((String)key.getKey()));
            }
            completions.add(Suggestion.suggestion((String)(key.getNamespace() + ':' + key.getKey())));
        });
        return CompletableFuture.completedFuture(completions);
    }

    @Value.Immutable
    public static interface RegistryEntry<E> {
        public E value();

        public NamespacedKey key();
    }

    public static final class ParseException
    extends ParserException {
        private final String input;
        private final RegistryKey<Object> registryKey;

        public ParseException(@NonNull String input, @NonNull RegistryKey<Object> registryKey, @NonNull CommandContext<?> context) {
            super(RegistryEntryParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_REGISTRY_ENTRY_MISSING, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input), CaptionVariable.of((String)"registry", (String)registryKey.key().asString())});
            this.input = input;
            this.registryKey = registryKey;
        }

        public @NonNull String input() {
            return this.input;
        }

        public @NonNull RegistryKey<Object> registryKey() {
            return this.registryKey;
        }
    }
}

