/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import kr.toxicity.model.api.pack.PackAssets;
import kr.toxicity.model.api.pack.PackBuilder;
import kr.toxicity.model.api.pack.PackPath;
import org.jetbrains.annotations.NotNull;

public final class PackNamespace {
    private final PackBuilder items;
    private final PackBuilder models;
    private final PackBuilder textures;

    PackNamespace(@NotNull PackAssets assets, @NotNull String namespace) {
        PackPath subPath = assets.path.resolve("assets", namespace);
        this.items = new PackBuilder(assets, subPath.resolve("items"));
        this.models = new PackBuilder(assets, subPath.resolve("models"));
        this.textures = new PackBuilder(assets, subPath.resolve("textures", "item"));
    }

    @NotNull
    public PackBuilder items() {
        return this.items;
    }

    @NotNull
    public PackBuilder models() {
        return this.models;
    }

    @NotNull
    public PackBuilder textures() {
        return this.textures;
    }
}

