/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Stream;
import kr.toxicity.model.AbstractBetterModelPlugin;
import kr.toxicity.model.BetterModelLibraryManager;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.util.function.BooleanConstantSupplier;
import kr.toxicity.model.shaded.net.byteflux.libby.Library;
import kr.toxicity.model.shaded.net.byteflux.libby.relocation.Relocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class BetterModelLibrary {
    private static final String KOTLIN_RELOCATED = "_kotlin".substring(1);
    private static final List<LibraryData> LIBRARY_DATA = new ArrayList<LibraryData>();
    public static final LibraryData KOTLIN = BetterModelLibrary.register("org{}jetbrains{}kotlin", KOTLIN_RELOCATED + "-stdlib", builder -> builder.relocation(KOTLIN_RELOCATED));
    public static final LibraryData BSTATS = BetterModelLibrary.register("org{}bstats", "bstats-bukkit", builder -> builder.relocation("org{}bstats").subModules("bstats-base"));
    public static final LibraryData CLOUD_CORE = BetterModelLibrary.register("org{}incendo", "cloud-core", builder -> builder.subModules("cloud-services").relocation("org{}incendo{}cloud"));
    public static final LibraryData GEANTYREF = BetterModelLibrary.register("io{}leangen{}geantyref", "geantyref", builder -> builder.predicate(BooleanConstantSupplier.of(!BetterModel.IS_PAPER)));
    public static final LibraryData MOLANG_COMPILER = BetterModelLibrary.register("gg{}moonflower", "molang-compiler", builder -> builder);
    public static final LibraryData ADVENTURE_API = BetterModelLibrary.register("net{}kyori", "adventure-api", builder -> builder.subModules("adventure-key", "adventure-text-logger-slf4j", "adventure-text-serializer-legacy", "adventure-nbt", "adventure-text-serializer-gson", "adventure-text-serializer-gson-legacy-impl", "adventure-text-serializer-json", "adventure-text-serializer-json-legacy-impl").predicate(BooleanConstantSupplier.of(!BetterModel.IS_PAPER)));
    public static final LibraryData EXAMINATION_API = BetterModelLibrary.register("net{}kyori", "examination-api", builder -> builder.subModules("examination-string").predicate(BooleanConstantSupplier.of(!BetterModel.IS_PAPER)));
    public static final LibraryData OPTION = BetterModelLibrary.register("net{}kyori", "option", builder -> builder.predicate(BooleanConstantSupplier.of(!BetterModel.IS_PAPER)));
    public static final LibraryData ADVENTURE_PLATFORM = BetterModelLibrary.register("net{}kyori", "adventure-platform-bukkit", builder -> builder.subModules("adventure-platform-api", "adventure-platform-facet", "adventure-platform-viaversion", "adventure-text-serializer-bungeecord").predicate(BooleanConstantSupplier.of(!BetterModel.IS_PAPER)));

    public void load(@NotNull AbstractBetterModelPlugin plugin) {
        BetterModelLibraryManager manager = new BetterModelLibraryManager(plugin);
        manager.addRepository("https://maven-central.storage-download.googleapis.com/maven2/");
        manager.addRepository("https://maven.blamejared.com/");
        manager.addMavenCentral();
        LIBRARY_DATA.stream().filter(LibraryData::isLoaded).flatMap(library -> library.toLibby(plugin)).forEach(manager::loadLibrary);
    }

    @NotNull
    private static LibraryData register(@NotNull String group, @NotNull String artifact, @NotNull Function<LibraryData.Builder, LibraryData.Builder> function) {
        LibraryData build = function.apply(new LibraryData.Builder(group, artifact)).build();
        LIBRARY_DATA.add(build);
        return build;
    }

    public record LibraryData(@NotNull String group, @NotNull String artifact, @Nullable String relocation, @NotNull String versionRef, @NotNull @Unmodifiable Set<String> subModules, @NotNull BooleanSupplier predicate) {
        public boolean isLoaded() {
            return this.predicate.getAsBoolean();
        }

        @NotNull
        private Stream<Library> toLibby(@NotNull AbstractBetterModelPlugin plugin) {
            String version = plugin.attributes().getValue("library-" + this.versionRef);
            return Stream.concat(Stream.of(this.artifact), this.subModules.stream()).map(name -> {
                Library.Builder libs = Library.builder().groupId(this.group).artifactId((String)name).version(version);
                if (this.relocation != null) {
                    libs.relocate(new Relocation(this.relocation, "kr{}toxicity{}model{}shaded{}" + this.relocation));
                }
                return libs.build();
            });
        }

        private static class Builder {
            final String group;
            final String artifact;
            @Nullable
            String relocation;
            @NotNull
            String versionRef;
            @NotNull
            @Unmodifiable Set<String> subModules = Collections.emptySet();
            @NotNull
            BooleanSupplier predicate = BooleanConstantSupplier.TRUE;

            Builder(@NotNull String group, @NotNull String artifact) {
                this.group = group;
                this.artifact = this.versionRef = artifact;
            }

            @NotNull
            Builder predicate(@NotNull BooleanSupplier predicate) {
                this.predicate = Objects.requireNonNull(predicate);
                return this;
            }

            @NotNull
            Builder subModules(String ... subModules) {
                this.subModules = Set.of(Objects.requireNonNull(subModules));
                return this;
            }

            @NotNull
            Builder relocation(@Nullable String relocation) {
                this.relocation = Objects.requireNonNull(relocation);
                return this;
            }

            @NotNull
            Builder versionRef(@NotNull String versionRef) {
                this.versionRef = Objects.requireNonNull(versionRef);
                return this;
            }

            @NotNull
            LibraryData build() {
                return new LibraryData(this.group, this.artifact, this.relocation, this.versionRef, this.subModules, this.predicate);
            }
        }
    }
}

