/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.org.incendo.cloud.bukkit.parser;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.BukkitCaptionKeys;
import kr.toxicity.model.shaded.org.incendo.cloud.caption.CaptionVariable;
import kr.toxicity.model.shaded.org.incendo.cloud.component.CommandComponent;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandContext;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandInput;
import kr.toxicity.model.shaded.org.incendo.cloud.exception.parsing.ParserException;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ArgumentParseResult;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ArgumentParser;
import kr.toxicity.model.shaded.org.incendo.cloud.parser.ParserDescriptor;
import kr.toxicity.model.shaded.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import kr.toxicity.model.shaded.org.incendo.cloud.suggestion.Suggestion;
import org.apiguardian.api.API;
import org.bukkit.Material;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MaterialParser<C>
implements ArgumentParser<C, Material>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Material> materialParser() {
        return ParserDescriptor.of(new MaterialParser<C>(), Material.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CommandComponent.Builder<C, Material> materialComponent() {
        return CommandComponent.builder().parser(MaterialParser.materialParser());
    }

    public @NonNull ArgumentParseResult<Material> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        try {
            Material material = Material.valueOf((String)input.toUpperCase(Locale.ROOT));
            return ArgumentParseResult.success((Object)material);
        }
        catch (IllegalArgumentException exception) {
            return ArgumentParseResult.failure((Throwable)((Object)new MaterialParseException(input, commandContext)));
        }
    }

    public @NonNull Iterable<@NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase).map(Suggestion::suggestion).collect(Collectors.toList());
    }

    public static final class MaterialParseException
    extends ParserException {
        private final String input;

        public MaterialParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(MaterialParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_MATERIAL, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

