/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.armormodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorByteBuilder;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorDataContext;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorDataResult;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorImage;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorModelContext;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorNameMapper;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorPaletteImage;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorResource;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorTrimPalette;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public record ArmorModel(@NotNull @Unmodifiable List<ArmorByteBuilder> builders, @NotNull @Unmodifiable Map<ArmorResource, ArmorDataResult> resources, @NotNull @Unmodifiable Map<String, ArmorTrimPalette> colors) {
    public static final ArmorModel EMPTY = new ArmorModel(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());

    @NotNull
    public ArmorDataResult resource(@NotNull ArmorResource resource) {
        return Objects.requireNonNull(this.resources.get((Object)resource));
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ArmorResource.StreamLoader streamLoader = ArmorResource.StreamLoader.DEFAULT;
        private List<ArmorImage> armors = Collections.emptyList();
        private List<ArmorImage> armorTrims = Collections.emptyList();
        private List<ArmorPaletteImage> palettes = Collections.emptyList();
        private String namespace = "armormodel";
        private ArmorNameMapper nameMapper = ArmorNameMapper.DEFAULT;
        private boolean flush = true;

        @NotNull
        public Builder streamLoader(@NotNull ArmorResource.StreamLoader streamLoader) {
            this.streamLoader = Objects.requireNonNull(streamLoader);
            return this;
        }

        @NotNull
        public Builder armors(@NotNull List<ArmorImage> armors) {
            this.armors = Objects.requireNonNull(armors);
            return this;
        }

        @NotNull
        public Builder armorTrims(@NotNull List<ArmorImage> armors) {
            this.armorTrims = Objects.requireNonNull(armors);
            return this;
        }

        @NotNull
        public Builder palettes(@NotNull List<ArmorPaletteImage> armors) {
            this.palettes = Objects.requireNonNull(armors);
            return this;
        }

        @NotNull
        public Builder namespace(@NotNull String namespace) {
            this.namespace = Objects.requireNonNull(namespace);
            return this;
        }

        @NotNull
        public Builder nameMapper(@NotNull ArmorNameMapper nameMapper) {
            this.nameMapper = Objects.requireNonNull(nameMapper);
            return this;
        }

        @NotNull
        public Builder flush(boolean flush) {
            this.flush = flush;
            return this;
        }

        @NotNull
        public ArmorModel build() {
            try (ArmorModelContext context = new ArmorModelContext(Arrays.stream(ArmorResource.values()).map(value -> new ArmorDataContext((ArmorResource)((Object)value), this.streamLoader)).toList(), this.namespace, this.nameMapper, this.flush);){
                context.loadArmor(this.armors);
                context.loadArmorTrim(this.armorTrims);
                ArmorModel armorModel = new ArmorModel(Collections.unmodifiableList(context.builders), context.results(), this.palettes.stream().collect(Collectors.toUnmodifiableMap(ArmorPaletteImage::name, p -> ArmorTrimPalette.from(p.image()))));
                return armorModel;
            }
        }

        @Generated
        private Builder() {
        }
    }
}

