/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.version;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public record MinecraftVersion(int major, int minor, int patch) implements Comparable<MinecraftVersion>
{
    public static final MinecraftVersion V1_21_11 = MinecraftVersion.of(1, 21, 11);
    public static final MinecraftVersion V1_21_10 = MinecraftVersion.of(1, 21, 10);
    public static final MinecraftVersion V1_21_9 = MinecraftVersion.of(1, 21, 9);
    public static final MinecraftVersion V1_21_8 = MinecraftVersion.of(1, 21, 8);
    public static final MinecraftVersion V1_21_7 = MinecraftVersion.of(1, 21, 7);
    public static final MinecraftVersion V1_21_6 = MinecraftVersion.of(1, 21, 6);
    public static final MinecraftVersion V1_21_5 = MinecraftVersion.of(1, 21, 5);
    public static final MinecraftVersion V1_21_4 = MinecraftVersion.of(1, 21, 4);
    public static final MinecraftVersion V1_21_3 = MinecraftVersion.of(1, 21, 3);
    public static final MinecraftVersion V1_21_2 = MinecraftVersion.of(1, 21, 2);
    public static final MinecraftVersion V1_21_1 = MinecraftVersion.of(1, 21, 1);
    public static final MinecraftVersion V1_21 = MinecraftVersion.of(1, 21, 0);
    public static final MinecraftVersion V1_20_6 = MinecraftVersion.of(1, 20, 6);
    public static final MinecraftVersion V1_20_5 = MinecraftVersion.of(1, 20, 5);
    private static final Comparator<MinecraftVersion> COMPARATOR = Comparator.comparing(MinecraftVersion::major).thenComparing(MinecraftVersion::minor).thenComparing(MinecraftVersion::patch);

    @NotNull
    public static MinecraftVersion parse(@NotNull String version) {
        String[] split = version.split("\\.");
        return MinecraftVersion.of(split.length > 0 ? Integer.parseInt(split[0]) : 0, split.length > 1 ? Integer.parseInt(split[1]) : 0, split.length > 2 ? Integer.parseInt(split[2]) : 0);
    }

    @NotNull
    public static MinecraftVersion of(int major, int minor, int patch) {
        return new MinecraftVersion(major, minor, patch);
    }

    public boolean isGreaterOrEquals(@NotNull MinecraftVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean useModernResource() {
        return this.isGreaterOrEquals(V1_21_4);
    }

    public boolean useItemModelName() {
        return this.isGreaterOrEquals(V1_21_2);
    }

    @Override
    public int compareTo(@NotNull MinecraftVersion o) {
        return COMPARATOR.compare(this, o);
    }

    @Override
    @NotNull
    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

