/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.entity.BaseEntity;
import kr.toxicity.model.api.profile.ModelProfile;
import kr.toxicity.model.api.tracker.DummyTracker;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.CollectionUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record ModelRenderer(@NotNull String name, @NotNull Type type, @NotNull @Unmodifiable Map<BoneName, RendererGroup> rendererGroups, @NotNull @Unmodifiable Map<String, BlueprintAnimation> animations) {
    @Nullable
    public RendererGroup groupByTree(@NotNull BoneName name) {
        return ModelRenderer.groupByTree0(this.rendererGroups, name);
    }

    @Nullable
    private static RendererGroup groupByTree0(@NotNull Map<BoneName, RendererGroup> map, @NotNull BoneName name) {
        if (map.isEmpty()) {
            return null;
        }
        RendererGroup get = map.get(name);
        if (get != null) {
            return get;
        }
        return map.values().stream().map(g -> ModelRenderer.groupByTree0(g.getChildren(), name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    public Stream<RendererGroup> flatten() {
        return this.rendererGroups.values().stream().flatMap(RendererGroup::flatten);
    }

    @NotNull
    public Optional<BlueprintAnimation> animation(@NotNull String name) {
        return Optional.ofNullable(this.animations().get(name));
    }

    @NotNull
    public DummyTracker create(@NotNull Location location) {
        return this.create(location, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull TrackerModifier modifier) {
        return this.create(location, modifier, (DummyTracker t) -> {});
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
        RenderSource.Dummy source = RenderSource.of(location);
        return source.create(this.pipeline(source), modifier, preUpdateConsumer);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull ModelProfile profile) {
        return this.create(location, profile.asUncompleted());
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, ModelProfile profile, @NotNull TrackerModifier modifier) {
        return this.create(location, profile.asUncompleted(), modifier);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull ModelProfile profile, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
        return this.create(location, profile.asUncompleted(), modifier, preUpdateConsumer);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull ModelProfile.Uncompleted profile) {
        return this.create(location, profile, TrackerModifier.DEFAULT);
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier) {
        return this.create(location, profile, modifier, (DummyTracker t) -> {});
    }

    @NotNull
    public DummyTracker create(@NotNull Location location, @NotNull ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
        RenderSource.Dummy source = RenderSource.of(location, profile);
        return source.create(this.pipeline(source), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity) {
        return this.create(BetterModel.nms().adapt(entity));
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull TrackerModifier modifier) {
        return this.create(BetterModel.nms().adapt(entity), modifier);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        return this.create(BetterModel.nms().adapt(entity), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull ModelProfile.Uncompleted profile) {
        return this.create(BetterModel.nms().adapt(entity), profile);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier) {
        return this.create(BetterModel.nms().adapt(entity), profile, modifier);
    }

    @NotNull
    public EntityTracker create(@NotNull Entity entity, @NotNull ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        return this.create(BetterModel.nms().adapt(entity), profile, modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity) {
        return this.getOrCreate(BetterModel.nms().adapt(entity));
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(BetterModel.nms().adapt(entity), modifier);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        return this.getOrCreate(BetterModel.nms().adapt(entity), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull ModelProfile profile) {
        return this.getOrCreate(entity, profile.asUncompleted());
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull ModelProfile profile, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(entity, profile.asUncompleted(), modifier);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull ModelProfile profile, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        return this.getOrCreate(entity, profile.asUncompleted(), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull ModelProfile.Uncompleted profile) {
        return this.getOrCreate(BetterModel.nms().adapt(entity), profile);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(BetterModel.nms().adapt(entity), profile, modifier);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull Entity entity, @NotNull ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        return this.getOrCreate(BetterModel.nms().adapt(entity), profile, modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity) {
        return this.create(entity, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity, @NotNull TrackerModifier modifier) {
        return this.create(entity, modifier, (EntityTracker t) -> {});
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        RenderSource.Entity source = RenderSource.of(entity);
        return source.create(this.pipeline(source), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity, @NotNull ModelProfile profile) {
        return this.create(entity, profile.asUncompleted());
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity, @NotNull ModelProfile profile, @NotNull TrackerModifier modifier) {
        return this.create(entity, profile.asUncompleted(), modifier);
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity, @NotNull ModelProfile profile, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        return this.create(entity, profile.asUncompleted(), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity, @NotNull ModelProfile.Uncompleted profile) {
        return this.create(entity, profile, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity, @NotNull ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier) {
        return this.create(entity, profile, modifier, (EntityTracker t) -> {});
    }

    @NotNull
    public EntityTracker create(@NotNull BaseEntity entity, @NotNull ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        RenderSource.Entity source = RenderSource.of(entity, profile);
        return source.create(this.pipeline(source), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity) {
        return this.getOrCreate(entity, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(entity, modifier, (EntityTracker t) -> {});
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        RenderSource.Entity source = RenderSource.of(entity);
        return source.getOrCreate(this.name(), () -> this.pipeline(source), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity, @NotNull ModelProfile profile) {
        return this.getOrCreate(entity, profile.asUncompleted());
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity, ModelProfile profile, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(entity, profile.asUncompleted(), modifier);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity, @NotNull ModelProfile profile, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        return this.getOrCreate(entity, profile.asUncompleted(), modifier, preUpdateConsumer);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity, @NotNull ModelProfile.Uncompleted profile) {
        return this.getOrCreate(entity, profile, TrackerModifier.DEFAULT);
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity, ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier) {
        return this.getOrCreate(entity, profile, modifier, (EntityTracker t) -> {});
    }

    @NotNull
    public EntityTracker getOrCreate(@NotNull BaseEntity entity, @NotNull ModelProfile.Uncompleted profile, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
        RenderSource.Entity source = RenderSource.of(entity, profile);
        return source.getOrCreate(this.name(), () -> this.pipeline(source), modifier, preUpdateConsumer);
    }

    @NotNull
    private RenderPipeline pipeline(@NotNull RenderSource<?> source) {
        return new RenderPipeline(this, source, CollectionUtil.mapValue(this.rendererGroups, value -> value.create(source)));
    }

    public static enum Type {
        GENERAL(true),
        PLAYER(false);

        private final boolean canBeSaved;

        @Generated
        private Type(boolean canBeSaved) {
            this.canBeSaved = canBeSaved;
        }

        @Generated
        public boolean isCanBeSaved() {
            return this.canBeSaved;
        }
    }
}

