/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.event.AnimationSignalEvent;
import kr.toxicity.model.api.manager.ScriptManager;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.script.AnimationScript;
import kr.toxicity.model.api.script.ScriptBuilder;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.script.BrightnessScript;
import kr.toxicity.model.script.ChangePartScript;
import kr.toxicity.model.script.EnchantScript;
import kr.toxicity.model.script.PartVisibilityScript;
import kr.toxicity.model.script.RemapScript;
import kr.toxicity.model.script.TintScript;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Pair;
import kr.toxicity.model.shaded.kotlin.TuplesKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.model.shaded.kotlin.text.StringsKt;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.FunctionsKt;
import kr.toxicity.model.util.ScriptsKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u000f*\u00020\u0007H\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkr/toxicity/model/manager/ScriptManagerImpl;", "Lkr/toxicity/model/api/manager/ScriptManager;", "Lkr/toxicity/model/manager/GlobalManager;", "<init>", "()V", "scriptMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/model/api/script/ScriptBuilder;", "Lkr/toxicity/model/shaded/kotlin/collections/HashMap;", "scriptPattern", "Ljava/util/regex/Pattern;", "kr.toxicity.model.shaded.kotlin.jvm.PlatformType", "validatePattern", "build", "Lkr/toxicity/model/api/script/AnimationScript;", "script", "addBuilder", "", "name", "reload", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "toScript", "ScriptMetaDataImpl", "core"})
@SourceDebugExtension(value={"SMAP\nScriptManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptManagerImpl.kt\nkr/toxicity/model/manager/ScriptManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n1193#3,2:114\n1267#3,4:116\n*S KotlinDebug\n*F\n+ 1 ScriptManagerImpl.kt\nkr/toxicity/model/manager/ScriptManagerImpl\n*L\n99#1:114,2\n99#1:116,4\n*E\n"})
public final class ScriptManagerImpl
implements ScriptManager,
GlobalManager {
    @NotNull
    public static final ScriptManagerImpl INSTANCE = new ScriptManagerImpl();
    @NotNull
    private static final HashMap<String, ScriptBuilder> scriptMap = new HashMap();
    private static final Pattern scriptPattern = Pattern.compile("^(?<name>[a-zA-Z]+)(:(?<argument>(\\w|_|-)+))?(\\{(?<metadata>(\\w|\\W)+)})?$");
    private static final Pattern validatePattern = Pattern.compile("^[a-z]+$");

    private ScriptManagerImpl() {
    }

    @Override
    @Nullable
    public AnimationScript build(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.toScript(script);
    }

    @Override
    public void addBuilder(@NotNull String name, @NotNull ScriptBuilder script) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (!validatePattern.matcher(name).find()) {
            throw new RuntimeException("name must be in [a-z]");
        }
        ((Map)scriptMap).put(name, script);
    }

    @Override
    public void reload(@NotNull ReloadPipeline pipeline, @NotNull PackZipper zipper) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
    }

    /*
     * WARNING - void declaration
     */
    private final AnimationScript toScript(String $this$toScript) {
        AnimationScript animationScript;
        Matcher matcher;
        Matcher matcher2;
        Matcher p0 = matcher2 = scriptPattern.matcher($this$toScript);
        boolean bl = false;
        Matcher matcher3 = matcher = p0.find() ? matcher2 : null;
        if (matcher != null) {
            Matcher it = matcher;
            boolean bl2 = false;
            String string = it.group("name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            ScriptBuilder scriptBuilder = scriptMap.get(string2);
            if (scriptBuilder != null) {
                Map map;
                char[] cArray;
                List list;
                String string3 = it.group("argument");
                String string4 = it.group("metadata");
                if (string4 != null && (list = StringsKt.split$default((CharSequence)string4, (char[])(cArray = new char[]{';'}), (boolean)false, (int)0, (int)6, null)) != null) {
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    Iterable iterable = list;
                    String string5 = string3;
                    ScriptBuilder scriptBuilder2 = scriptBuilder;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    void var14_14 = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv;
                        String pair = (String)element$iv$iv;
                        boolean bl3 = false;
                        char[] cArray2 = new char[]{'='};
                        List arr = StringsKt.split$default((CharSequence)pair, (char[])cArray2, (boolean)false, (int)2, (int)2, null);
                        boolean bl4 = false;
                        Pair pair2 = TuplesKt.to(arr.get(0), arr.get(1));
                        map2.put(pair2.getFirst(), pair2.getSecond());
                    }
                    Map map3 = destination$iv$iv;
                    scriptBuilder = scriptBuilder2;
                    string3 = string5;
                    map = map3;
                } else {
                    map = MapsKt.emptyMap();
                }
                Map map4 = map;
                ScriptBuilder.ScriptMetaData scriptMetaData = new ScriptMetaDataImpl(map4);
                String string6 = string3;
                animationScript = scriptBuilder.build(new ScriptBuilder.ScriptData(string6, scriptMetaData));
            } else {
                animationScript = null;
            }
        } else {
            animationScript = null;
        }
        return animationScript;
    }

    private static final AnimationScript _init_$lambda$0(ScriptBuilder.ScriptData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.args();
        if (string == null) {
            return AnimationScript.EMPTY;
        }
        String args = string;
        return AnimationScript.of(arg_0 -> ScriptManagerImpl.lambda$0$0(args, arg_0));
    }

    private static final void lambda$0$0(String $args, Tracker tracker) {
        tracker.getPipeline().allPlayer().forEach(arg_0 -> ScriptManagerImpl.lambda$0$0$1(arg_0 -> ScriptManagerImpl.lambda$0$0$0($args, arg_0), arg_0));
    }

    private static final Unit lambda$0$0$0(String $args, Player player) {
        EventsKt.call(new AnimationSignalEvent(player, $args));
        return Unit.INSTANCE;
    }

    private static final void lambda$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final AnimationScript _init_$lambda$1(ScriptBuilder.ScriptData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScriptBuilder.ScriptMetaData scriptMetaData = it.metadata();
        Intrinsics.checkNotNullExpressionValue((Object)scriptMetaData, (String)"metadata(...)");
        Number number = it.metadata().asNumber("color");
        if (number == null) {
            return AnimationScript.EMPTY;
        }
        return new TintScript(ScriptsKt.getBonePredicate(scriptMetaData), number.intValue(), Intrinsics.areEqual((Object)it.metadata().asBoolean("damage"), (Object)true));
    }

    private static final AnimationScript _init_$lambda$2(ScriptBuilder.ScriptData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScriptBuilder.ScriptMetaData scriptMetaData = it.metadata();
        Intrinsics.checkNotNullExpressionValue((Object)scriptMetaData, (String)"metadata(...)");
        Boolean bl = it.metadata().asBoolean("visible");
        if (bl == null) {
            return AnimationScript.EMPTY;
        }
        return new PartVisibilityScript(ScriptsKt.getBonePredicate(scriptMetaData), bl);
    }

    private static final AnimationScript _init_$lambda$3(ScriptBuilder.ScriptData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScriptBuilder.ScriptMetaData scriptMetaData = it.metadata();
        Intrinsics.checkNotNullExpressionValue((Object)scriptMetaData, (String)"metadata(...)");
        Number number = it.metadata().asNumber("block");
        if (number == null) {
            return AnimationScript.EMPTY;
        }
        Number number2 = it.metadata().asNumber("sky");
        if (number2 == null) {
            return AnimationScript.EMPTY;
        }
        return new BrightnessScript(ScriptsKt.getBonePredicate(scriptMetaData), number.intValue(), number2.intValue());
    }

    private static final AnimationScript _init_$lambda$4(ScriptBuilder.ScriptData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScriptBuilder.ScriptMetaData scriptMetaData = it.metadata();
        Intrinsics.checkNotNullExpressionValue((Object)scriptMetaData, (String)"metadata(...)");
        Boolean bl = it.metadata().asBoolean("enchant");
        if (bl == null) {
            return AnimationScript.EMPTY;
        }
        return new EnchantScript(ScriptsKt.getBonePredicate(scriptMetaData), bl);
    }

    private static final AnimationScript _init_$lambda$5(ScriptBuilder.ScriptData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ScriptBuilder.ScriptMetaData scriptMetaData = it.metadata();
        Intrinsics.checkNotNullExpressionValue((Object)scriptMetaData, (String)"metadata(...)");
        String string = it.metadata().asString("nmodel");
        if (string == null) {
            return AnimationScript.EMPTY;
        }
        Object object = it.metadata().asString("npart");
        if (object == null || (object = FunctionsKt.getBoneName((String)object)) == null) {
            return AnimationScript.EMPTY;
        }
        return new ChangePartScript(ScriptsKt.getBonePredicate(scriptMetaData), string, (BoneName)object);
    }

    private static final AnimationScript _init_$lambda$6(ScriptBuilder.ScriptData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.metadata().asString("model");
        if (string == null) {
            return AnimationScript.EMPTY;
        }
        return new RemapScript(string, it.metadata().asString("map"));
    }

    static {
        INSTANCE.addBuilder("signal", ScriptManagerImpl::_init_$lambda$0);
        INSTANCE.addBuilder("tint", ScriptManagerImpl::_init_$lambda$1);
        INSTANCE.addBuilder("partvis", ScriptManagerImpl::_init_$lambda$2);
        INSTANCE.addBuilder("partbright", ScriptManagerImpl::_init_$lambda$3);
        INSTANCE.addBuilder("enchant", ScriptManagerImpl::_init_$lambda$4);
        INSTANCE.addBuilder("changepart", ScriptManagerImpl::_init_$lambda$5);
        INSTANCE.addBuilder("remap", ScriptManagerImpl::_init_$lambda$6);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkr/toxicity/model/manager/ScriptManagerImpl$ScriptMetaDataImpl;", "Lkr/toxicity/model/api/script/ScriptBuilder$ScriptMetaData;", "map", "", "", "<init>", "(Ljava/util/Map;)V", "toMap", "core"})
    private static final class ScriptMetaDataImpl
    implements ScriptBuilder.ScriptMetaData {
        @NotNull
        private final Map<String, String> map;

        public ScriptMetaDataImpl(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
        }

        @Override
        @NotNull
        public Map<String, String> toMap() {
            return this.map;
        }
    }
}

