/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.ModelInteractionHand;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.manager.EntityManager;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.util.EventsKt;
import kr.toxicity.model.util.PluginsKt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002!\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J \u0010\u0015\u001a\u00020\u000e*\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0014\u0010\u001e\u001a\u00020\u000e*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkr/toxicity/model/manager/EntityManager;", "Lkr/toxicity/model/manager/GlobalManager;", "<init>", "()V", "effectSet", "Lit/unimi/dsi/fastutil/objects/ReferenceSet;", "Lorg/bukkit/potion/PotionEffectType;", "kr.toxicity.model.shaded.kotlin.jvm.PlatformType", "standardListener", "kr/toxicity/model/manager/EntityManager$standardListener$1", "Lkr/toxicity/model/manager/EntityManager$standardListener$1;", "platformListener", "Lorg/bukkit/event/Listener;", "start", "", "reload", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "end", "forEachTracker", "Lorg/bukkit/entity/Entity;", "block", "Lkr/toxicity/model/shaded/kotlin/Function1;", "Lkr/toxicity/model/api/tracker/EntityTracker;", "triggerDismount", "", "Lorg/bukkit/entity/Player;", "e", "triggerMount", "hitBox", "Lkr/toxicity/model/api/nms/HitBox;", "PaperListener", "SpigotListener", "core"})
@SourceDebugExtension(value={"SMAP\nEntityManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityManager.kt\nkr/toxicity/model/manager/EntityManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1869#2,2:203\n*S KotlinDebug\n*F\n+ 1 EntityManager.kt\nkr/toxicity/model/manager/EntityManager\n*L\n185#1:203,2\n*E\n"})
public final class EntityManager
implements GlobalManager {
    @NotNull
    public static final EntityManager INSTANCE = new EntityManager();
    private static final ReferenceSet<PotionEffectType> effectSet = ReferenceSet.of((Object)PotionEffectType.GLOWING, (Object)PotionEffectType.INVISIBILITY);
    @NotNull
    private static final standardListener.1 standardListener = new Listener(){

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void potion(EntityPotionEffectEvent $this$potion) {
            block9: {
                block8: {
                    boolean bl;
                    boolean bl2;
                    PotionEffect it;
                    Intrinsics.checkNotNullParameter((Object)$this$potion, (String)"<this>");
                    if ($this$potion.getAction() == EntityPotionEffectEvent.Action.CHANGED) {
                        return;
                    }
                    PotionEffect potionEffect = $this$potion.getOldEffect();
                    if (potionEffect != null) {
                        it = potionEffect;
                        boolean bl3 = false;
                        bl2 = EntityManager.access$getEffectSet$p().contains((Object)it.getType());
                    } else {
                        bl2 = false;
                    }
                    if (bl2) break block8;
                    PotionEffect potionEffect2 = $this$potion.getNewEffect();
                    if (potionEffect2 != null) {
                        it = potionEffect2;
                        boolean bl4 = false;
                        bl = EntityManager.access$getEffectSet$p().contains((Object)it.getType());
                    } else {
                        bl = false;
                    }
                    if (!bl) break block9;
                }
                Entity entity = $this$potion.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
                EntityManager.access$forEachTracker(EntityManager.INSTANCE, entity, standardListener.1::potion$lambda$2);
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void dismount(EntityDismountEvent $this$dismount) {
            Intrinsics.checkNotNullParameter((Object)$this$dismount, (String)"<this>");
            Entity entity = $this$dismount.getDismounted();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getDismounted(...)");
            Entity e = entity;
            $this$dismount.setCancelled(e instanceof HitBox && (((HitBox)e).mountController().canFly() || !((HitBox)e).mountController().canDismountBySelf()) && !((HitBox)e).forceDismount());
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void quit(PlayerQuitEvent $this$quit) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)$this$quit, (String)"<this>");
                EntityTrackerRegistry entityTrackerRegistry = BetterModel.registryOrNull($this$quit.getPlayer().getUniqueId());
                if (entityTrackerRegistry != null) {
                    entityTrackerRegistry.close();
                }
                PluginsKt.getPLUGIN().scheduler().asyncTask(() -> standardListener.1.quit$lambda$3($this$quit));
                Entity entity = $this$quit.getPlayer().getVehicle();
                HitBox hitBox = entity instanceof HitBox ? (HitBox)entity : null;
                if (hitBox == null) break block1;
                hitBox.dismount((Entity)$this$quit.getPlayer());
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void load(EntitiesLoadEvent $this$load) {
            Intrinsics.checkNotNullParameter((Object)$this$load, (String)"<this>");
            List list = $this$load.getEntities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                Entity entity = (Entity)element$iv;
                boolean bl = false;
                EntityTrackerRegistry entityTrackerRegistry = BetterModel.registryOrNull(entity.getUniqueId());
                if (entityTrackerRegistry == null) continue;
                entityTrackerRegistry.refresh();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void unload(EntitiesUnloadEvent $this$unload) {
            Intrinsics.checkNotNullParameter((Object)$this$unload, (String)"<this>");
            List list = $this$unload.getEntities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                Entity entity = (Entity)element$iv;
                boolean bl = false;
                EntityTrackerRegistry entityTrackerRegistry = BetterModel.registryOrNull(entity.getUniqueId());
                if (entityTrackerRegistry == null) continue;
                entityTrackerRegistry.despawn();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void death(EntityDeathEvent $this$death) {
            Intrinsics.checkNotNullParameter((Object)$this$death, (String)"<this>");
            LivingEntity livingEntity = $this$death.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
            EntityManager.access$forEachTracker(EntityManager.INSTANCE, (Entity)livingEntity, standardListener.1::death$lambda$6);
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void interact(PlayerInteractAtEntityEvent $this$interact) {
            block4: {
                ModelInteractionHand modelInteractionHand;
                Intrinsics.checkNotNullParameter((Object)$this$interact, (String)"<this>");
                Entity entity = $this$interact.getRightClicked();
                HitBox hitBox = entity instanceof HitBox ? (HitBox)entity : null;
                if (hitBox == null) break block4;
                Player player = $this$interact.getPlayer();
                switch (standardListener.WhenMappings.$EnumSwitchMapping$0[$this$interact.getHand().ordinal()]) {
                    case 1: {
                        modelInteractionHand = ModelInteractionHand.RIGHT;
                        break;
                    }
                    case 2: {
                        modelInteractionHand = ModelInteractionHand.LEFT;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                hitBox.triggerInteractAt(player, modelInteractionHand, $this$interact.getClickedPosition());
            }
        }

        /*
         * Unable to fully structure code
         */
        @EventHandler(priority=EventPriority.MONITOR)
        public final void interact(PlayerInteractEntityEvent $this$interact) {
            block7: {
                Intrinsics.checkNotNullParameter((Object)$this$interact, (String)"<this>");
                v0 = isRight = $this$interact.getHand() == EquipmentSlot.HAND;
                if (!isRight) ** GOTO lbl-1000
                v1 = $this$interact.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPlayer(...)");
                v2 = $this$interact.getRightClicked();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getRightClicked(...)");
                if (EntityManager.access$triggerDismount(EntityManager.INSTANCE, v1, v2)) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                dismount = v3;
                var4_4 = $this$interact.getRightClicked();
                v4 = var4_4 instanceof HitBox != false ? (HitBox)var4_4 : null;
                if (v4 == null) break block7;
                it = v4;
                $i$a$-let-EntityManager$standardListener$1$interact$1 = false;
                v5 = $this$interact.getPlayer();
                switch (standardListener.WhenMappings.$EnumSwitchMapping$0[$this$interact.getHand().ordinal()]) {
                    case 1: {
                        v6 = ModelInteractionHand.RIGHT;
                        break;
                    }
                    case 2: {
                        v6 = ModelInteractionHand.LEFT;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                it.triggerInteract(v5, v6);
                if (isRight && !dismount) {
                    v7 = $this$interact.getPlayer();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getPlayer(...)");
                    EntityManager.access$triggerMount(EntityManager.INSTANCE, v7, it);
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void damage(EntityDamageEvent $this$damage) {
            Intrinsics.checkNotNullParameter((Object)$this$damage, (String)"<this>");
            if ($this$damage instanceof EntityDamageByEntityEvent) {
                Entity $this$damage_u24lambda_u248 = ((EntityDamageByEntityEvent)$this$damage).getEntity();
                boolean bl = false;
                UUID uUID = $this$damage_u24lambda_u248 instanceof HitBox ? ((HitBox)$this$damage_u24lambda_u248).source().getUniqueId() : $this$damage_u24lambda_u248.getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"run(...)");
                UUID victim = uUID;
                Entity v = ((EntityDamageByEntityEvent)$this$damage).getDamager().getVehicle();
                if (v instanceof HitBox && !((HitBox)v).mountController().canBeDamagedByRider() && Intrinsics.areEqual((Object)((HitBox)v).source().getUniqueId(), (Object)victim)) {
                    ((EntityDamageByEntityEvent)$this$damage).setCancelled(true);
                    return;
                }
            }
            Entity entity = $this$damage.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
            EntityManager.access$forEachTracker(EntityManager.INSTANCE, entity, standardListener.1::damage$lambda$9);
        }

        private static final Unit potion$lambda$2(EntityTracker it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.updateBaseEntity();
            return Unit.INSTANCE;
        }

        private static final void quit$lambda$3(PlayerQuitEvent $this_quit) {
            EntityTrackerRegistry.registries(arg_0 -> standardListener.1.quit$lambda$3$0($this_quit, arg_0));
        }

        private static final void quit$lambda$3$0(PlayerQuitEvent $this_quit, EntityTrackerRegistry registry) {
            registry.remove($this_quit.getPlayer());
        }

        private static final Unit death$lambda$6(EntityTracker it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (it.animate("death", AnimationModifier.DEFAULT_WITH_PLAY_ONCE, it::close)) {
                it.forRemoval(true);
            }
            return Unit.INSTANCE;
        }

        private static final Unit damage$lambda$9(EntityTracker it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.animate("damage", AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
            it.damageTint();
            return Unit.INSTANCE;
        }
    };
    @NotNull
    private static final Listener platformListener = BetterModel.IS_PAPER ? (Listener)new PaperListener() : (Listener)new SpigotListener();

    private EntityManager() {
    }

    @Override
    public void start() {
        EventsKt.registerListener(standardListener);
        EventsKt.registerListener(platformListener);
    }

    @Override
    public void reload(@NotNull ReloadPipeline pipeline, @NotNull PackZipper zipper) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
        EntityTrackerRegistry.registries(EntityTrackerRegistry::reload);
    }

    @Override
    public void end() {
        EntityTrackerRegistry.registries(EntityTrackerRegistry::save);
    }

    private final void forEachTracker(Entity $this$forEachTracker, Function1<? super EntityTracker, Unit> block) {
        block1: {
            Object object = BetterModel.registryOrNull($this$forEachTracker.getUniqueId());
            if (object == null || (object = ((EntityTrackerRegistry)object).trackers()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                block.invoke(element$iv);
            }
        }
    }

    private final boolean triggerDismount(Player $this$triggerDismount, Entity e) {
        Entity previous = $this$triggerDismount.getVehicle();
        if (!(previous instanceof HitBox)) {
            return false;
        }
        UUID uUID = e instanceof HitBox ? ((HitBox)e).source().getUniqueId() : e.getUniqueId();
        Intrinsics.checkNotNull((Object)uUID);
        UUID uuid = uUID;
        if (Intrinsics.areEqual((Object)((HitBox)previous).source().getUniqueId(), (Object)uuid) && ((HitBox)previous).mountController().canDismountBySelf()) {
            ((HitBox)previous).dismount((Entity)$this$triggerDismount);
            return true;
        }
        return false;
    }

    private final void triggerMount(Player $this$triggerMount, HitBox hitBox) {
        if (hitBox.mountController().canMount()) {
            hitBox.mount((Entity)$this$triggerMount);
        }
    }

    public static final /* synthetic */ boolean access$triggerDismount(EntityManager $this, Player $receiver, Entity e) {
        return $this.triggerDismount($receiver, e);
    }

    public static final /* synthetic */ ReferenceSet access$getEffectSet$p() {
        return effectSet;
    }

    public static final /* synthetic */ void access$triggerMount(EntityManager $this, Player $receiver, HitBox hitBox) {
        $this.triggerMount($receiver, hitBox);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0007J\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lkr/toxicity/model/manager/EntityManager$PaperListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "remove", "", "Lcom/destroystokyo/paper/event/entity/EntityRemoveFromWorldEvent;", "add", "Lcom/destroystokyo/paper/event/entity/EntityAddToWorldEvent;", "jump", "Lcom/destroystokyo/paper/event/entity/EntityJumpEvent;", "core"})
    private static final class PaperListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public final void remove(@NotNull EntityRemoveFromWorldEvent $this$remove) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this$remove, (String)"<this>");
                EntityTrackerRegistry entityTrackerRegistry = BetterModel.registryOrNull($this$remove.getEntity().getUniqueId());
                if (entityTrackerRegistry == null) break block0;
                entityTrackerRegistry.despawn();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void add(@NotNull EntityAddToWorldEvent $this$add) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
                EntityTrackerRegistry entityTrackerRegistry = BetterModel.registryOrNull($this$add.getEntity());
                if (entityTrackerRegistry == null) break block0;
                entityTrackerRegistry.refresh();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void jump(@NotNull EntityJumpEvent $this$jump) {
            Intrinsics.checkNotNullParameter((Object)$this$jump, (String)"<this>");
            LivingEntity livingEntity = $this$jump.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
            INSTANCE.forEachTracker((Entity)livingEntity, (Function1<? super EntityTracker, Unit>)PaperListener::jump$lambda$0);
        }

        private static final Unit jump$lambda$0(EntityTracker it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.animate("jump");
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0007J\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lkr/toxicity/model/manager/EntityManager$SpigotListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "remove", "", "Lorg/bukkit/event/entity/EntityRemoveEvent;", "spawn", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "change", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "core"})
    private static final class SpigotListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public final void remove(@NotNull EntityRemoveEvent $this$remove) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this$remove, (String)"<this>");
                EntityTrackerRegistry entityTrackerRegistry = BetterModel.registryOrNull($this$remove.getEntity().getUniqueId());
                if (entityTrackerRegistry == null) break block0;
                entityTrackerRegistry.despawn();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public final void spawn(@NotNull EntitySpawnEvent $this$spawn) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this$spawn, (String)"<this>");
                EntityTrackerRegistry entityTrackerRegistry = BetterModel.registryOrNull($this$spawn.getEntity());
                if (entityTrackerRegistry == null) break block0;
                entityTrackerRegistry.refresh();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void change(@NotNull PlayerChangedWorldEvent $this$change) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"<this>");
                EntityTrackerRegistry entityTrackerRegistry = BetterModel.registryOrNull($this$change.getPlayer().getUniqueId());
                if (entityTrackerRegistry == null) break block0;
                EntityTrackerRegistry it = entityTrackerRegistry;
                boolean bl = false;
                it.despawn();
                it.refresh();
            }
        }
    }
}

