/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.mount.MountController;
import kr.toxicity.model.api.mount.MountControllers;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RendererGroup {
    private static final Vector3f DEFAULT_SCALE = new Vector3f(1.0f);
    private final BlueprintElement.Bone parent;
    private final Vector3f position;
    private final Vector3f rotation;
    private final TransformedItemStack itemStack;
    private final @Unmodifiable Map<BoneName, RendererGroup> children;
    @Nullable
    private final NamedBoundingBox hitBox;
    @NotNull
    private final BoneItemMapper itemMapper;
    @NotNull
    private final MountController mountController;

    public RendererGroup(float scale2, @Nullable ItemStack itemStack, @NotNull BlueprintElement.Bone group, @NotNull Map<BoneName, RendererGroup> children, @Nullable NamedBoundingBox box) {
        this.parent = group;
        this.children = children;
        this.itemStack = TransformedItemStack.of(new Vector3f(), new Vector3f(), new Vector3f(scale2), itemStack != null ? itemStack : new ItemStack(Material.AIR));
        this.itemMapper = this.name().toItemMapper();
        this.position = group.origin().toBlockScale().toVector();
        this.hitBox = box;
        this.rotation = group.rotation().toVector();
        this.mountController = this.name().tagged(BoneTags.SEAT) ? BetterModel.config().defaultMountController() : (this.name().tagged(BoneTags.SUB_SEAT) ? MountControllers.NONE : MountControllers.INVALID);
    }

    @NotNull
    public Stream<RendererGroup> flatten() {
        return Stream.concat(Stream.of(this), this.children.values().stream().flatMap(RendererGroup::flatten));
    }

    @NotNull
    public BoneName name() {
        return this.parent.name();
    }

    @NotNull
    public UUID uuid() {
        return this.parent.uuid();
    }

    @NotNull
    public RenderedBone create(@NotNull RenderSource<?> source) {
        return this.create(source, null);
    }

    @NotNull
    private RenderedBone create(@NotNull RenderSource<?> source, @Nullable RenderedBone parentBone) {
        return new RenderedBone(this, parentBone, source, new BoneMovement(parentBone != null ? this.position.sub((Vector3fc)parentBone.getGroup().position, new Vector3f()) : new Vector3f(), DEFAULT_SCALE, MathUtil.toQuaternion(this.rotation), this.rotation), parent -> CollectionUtil.mapValue(this.children, value -> value.create(source, (RenderedBone)parent)));
    }

    @NotNull
    public TransformedItemStack getItemStack() {
        return this.itemStack.copy();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RendererGroup)) {
            return false;
        }
        RendererGroup that = (RendererGroup)o;
        return this.uuid().equals(that.uuid());
    }

    public int hashCode() {
        return this.uuid().hashCode();
    }

    @Generated
    public RendererGroup(BlueprintElement.Bone parent, Vector3f position, Vector3f rotation2, TransformedItemStack itemStack, Map<BoneName, RendererGroup> children, @Nullable NamedBoundingBox hitBox, @NotNull BoneItemMapper itemMapper, @NotNull MountController mountController) {
        if (itemMapper == null) {
            throw new NullPointerException("itemMapper is marked non-null but is null");
        }
        if (mountController == null) {
            throw new NullPointerException("mountController is marked non-null but is null");
        }
        this.parent = parent;
        this.position = position;
        this.rotation = rotation2;
        this.itemStack = itemStack;
        this.children = children;
        this.hitBox = hitBox;
        this.itemMapper = itemMapper;
        this.mountController = mountController;
    }

    @Generated
    public BlueprintElement.Bone getParent() {
        return this.parent;
    }

    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @Generated
    public Map<BoneName, RendererGroup> getChildren() {
        return this.children;
    }

    @Nullable
    @Generated
    public NamedBoundingBox getHitBox() {
        return this.hitBox;
    }

    @NotNull
    @Generated
    public BoneItemMapper getItemMapper() {
        return this.itemMapper;
    }

    @NotNull
    @Generated
    public MountController getMountController() {
        return this.mountController;
    }
}

