/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.bukkit;

import com.tom.cpl.command.StringCommandHandler;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.TextRemapper;
import com.tom.cpm.bukkit.CPMBukkitPlugin;
import com.tom.cpm.bukkit.CommandHandler;
import com.tom.cpm.bukkit.text.BukkitText;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commands {

    public static class FallbackCommandHandler
    extends StringCommandHandler<Void, CommandSender, CommandException>
    implements CommandHandler {
        private Map<String, StringCommandHandler.CommandImpl> commands;
        private CPMBukkitPlugin plugin;

        private FallbackCommandHandler(CPMBukkitPlugin pl, Map<String, StringCommandHandler.CommandImpl> commands) {
            super((StringCommandHandler.CommandImpl i) -> {
                commands.put(i.getName(), (StringCommandHandler.CommandImpl)i);
                pl.getCommand(i.getName()).setExecutor((CommandExecutor)pl);
            }, false);
            this.plugin = pl;
            this.commands = commands;
        }

        public FallbackCommandHandler(CPMBukkitPlugin pl) {
            this(pl, new HashMap<String, StringCommandHandler.CommandImpl>());
        }

        @Override
        public boolean onCommand(CommandSender s, Command cmdIn, String name, String[] args) {
            try {
                StringCommandHandler.CommandImpl cmd = this.commands.get(cmdIn.getName());
                if (cmd != null) {
                    cmd.execute(null, s, args);
                }
            }
            catch (CommandException e) {
                s.sendMessage(ChatColor.RED + ((BukkitText)e.msg.remap()).toString());
                return false;
            }
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            StringCommandHandler.CommandImpl cmd = this.commands.get(command.getName());
            if (cmd != null) {
                return cmd.getTabCompletions(null, null, args);
            }
            return Collections.emptyList();
        }

        @Override
        public String toStringPlayer(Object pl) {
            return ((Player)pl).getDisplayName();
        }

        @Override
        public void sendSuccess(CommandSender sender, IText text) {
            ((BukkitText)text.remap()).sendTo(sender);
        }

        @Override
        public List<String> getOnlinePlayers(Void server) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        }

        @Override
        public CommandException generic(String text, Object ... format) {
            return new CommandException(new FormatText(text, format));
        }

        @Override
        public CommandException wrongUsage(String text, Object ... format) {
            return new CommandException(new FormatText(text, format));
        }

        @Override
        public Object getPlayerObj(Void server, CommandSender sender, String name) throws CommandException {
            return Bukkit.getPlayer((String)name);
        }

        @Override
        public CommandException checkExc(Exception exc) {
            if (exc instanceof CommandException) {
                return (CommandException)exc;
            }
            return new CommandException(new FormatText("commands.generic.exception", new Object[0]));
        }

        public TextRemapper<BukkitText.Simple> remapper() {
            return BukkitText.simple(this.plugin);
        }
    }

    private static class CommandException
    extends Exception {
        private static final long serialVersionUID = 3508944502637337553L;
        private IText msg;

        public CommandException(IText msg) {
            this.msg = msg;
        }
    }
}

