/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.skin;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.Hashing;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.LegacySkinConverter;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public abstract class PlayerTextureLoader {
    private static final LoadingCache<String, CompletableFuture<Image>> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(CacheLoader.from(Image::download));
    private Map<TextureType, Texture> textures = new ConcurrentHashMap<TextureType, Texture>();
    private final File skinsDirectory;
    private CompletableFuture<Void> loadFuture;

    public CompletableFuture<Void> load() {
        if (this.loadFuture == null) {
            this.loadFuture = this.load0();
        }
        return this.loadFuture;
    }

    public PlayerTextureLoader() {
        this.skinsDirectory = null;
    }

    public PlayerTextureLoader(File skinsDirectory) {
        this.skinsDirectory = skinsDirectory;
    }

    protected abstract CompletableFuture<Void> load0();

    protected void defineTexture(TextureType type, String url) {
        this.textures.computeIfAbsent(type, Texture::new).url = url;
    }

    protected void defineTexture(TextureType type, String url, String hash) {
        Texture tx = this.textures.computeIfAbsent(type, Texture::new);
        tx.url = url;
        if (this.skinsDirectory != null) {
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)hash).toString();
            File file1 = new File(this.skinsDirectory, s.length() > 2 ? s.substring(0, 2) : "xx");
            tx.cachedFile = new File(file1, s);
        }
    }

    protected void defineTexture(TextureType type, String url, File file) {
        Texture tx = this.textures.computeIfAbsent(type, Texture::new);
        tx.url = url;
        tx.cachedFile = file;
    }

    protected <Ty extends Enum<Ty>> void defineTexture(Ty type, String url) {
        this.defineTexture(TextureType.valueOf(type.name()), url);
    }

    protected <Ty extends Enum<Ty>> void defineTexture(Ty type, String url, String hash) {
        this.defineTexture(TextureType.valueOf(type.name()), url, hash);
    }

    protected <Ty extends Enum<Ty>, Tx> void defineAll(Map<Ty, Tx> map, Function<Tx, String> toURL) {
        for (Map.Entry<Ty, Tx> e : map.entrySet()) {
            this.defineTexture(TextureType.valueOf(((Enum)e.getKey()).name()), toURL.apply(e.getValue()));
        }
    }

    protected <Ty extends Enum<Ty>, Tx> void defineAll(Map<Ty, Tx> map, Function<Tx, String> toURL, Function<Tx, String> toHash) {
        for (Map.Entry<Ty, Tx> e : map.entrySet()) {
            this.defineTexture(TextureType.valueOf(((Enum)e.getKey()).name()), toURL.apply(e.getValue()), toHash.apply(e.getValue()));
        }
    }

    public CompletableFuture<Image> getTexture(TextureType type) {
        return this.textures.computeIfAbsent(type, Texture::new).get();
    }

    private static class Texture {
        private final TextureType type;
        private CompletableFuture<Image> skinFuture;
        private String url;
        private File cachedFile;
        private UnaryOperator<Image> postProcessor;

        public Texture(TextureType type) {
            this.postProcessor = type == TextureType.SKIN ? LegacySkinConverter::processLegacySkin : UnaryOperator.identity();
            this.type = type;
        }

        public CompletableFuture<Image> get() {
            if (this.skinFuture != null) {
                return this.skinFuture;
            }
            this.skinFuture = this.get0();
            if (this.skinFuture == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.skinFuture;
        }

        private CompletableFuture<Image> get0() {
            if (MinecraftObjectHolder.DEBUGGING && new File(this.type.name().toLowerCase(Locale.ROOT) + "_test.png").exists()) {
                return Image.loadFrom(new File(this.type.name().toLowerCase(Locale.ROOT) + "_test.png")).thenApply(this.postProcessor);
            }
            if (this.url == null) {
                return null;
            }
            if (this.cachedFile != null && this.cachedFile.isFile()) {
                return ((CompletableFuture)Image.loadFrom(this.cachedFile).thenApply(this.postProcessor)).exceptionally(e -> null);
            }
            return ((CompletableFuture)((CompletableFuture)cache.getUnchecked((Object)this.url)).thenApply(this.postProcessor)).exceptionally(e -> null);
        }
    }
}

