/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;

public class SkinLayerParameterValueAction
implements CommandAction,
CommandAction.LegacyCommandActionWriter {
    private final String name;
    private ModelDefinition def;
    public int parameter;
    public int value;
    public boolean pose;
    public int gid;
    private boolean cc;

    public SkinLayerParameterValueAction(String name, ModelDefinition def, int parameter, int value, boolean pose, int gid, boolean cc) {
        this.name = name;
        this.def = def;
        this.parameter = parameter;
        this.pose = pose;
        this.value = value;
        this.cc = cc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.setInteger("param", this.parameter);
        tag.setByte("value", (byte)this.value);
        tag.setBoolean("cc", this.cc);
    }

    @Override
    public void writeLegacy(NBTTagCompound tag) {
        tag.setString("name", this.name);
        tag.setByte("id", (byte)this.parameter);
        tag.setByte("type", (byte)((this.cc ? 16 : 0) | (this.pose ? 0 : 1)));
    }

    @Override
    public CommandAction.ActionType getType() {
        return CommandAction.ActionType.SIMPLE;
    }

    @Override
    public int getValue() {
        AnimationEngine an = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine();
        return an.getGestureValue(this.parameter) == this.value ? 1 : 0;
    }

    @Override
    public void setValue(int v) {
        if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            AnimationEngine an = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine();
            if (v == -1 && an.getGestureValue(this.parameter) == this.value || v == 0) {
                an.setGestureValue(this.parameter, 0);
            } else {
                an.setGestureValue(this.parameter, this.value);
            }
        } else {
            Player<?> pl = this.def.getPlayerObj();
            int id = pl.animState.encodedState == this.gid ? (this.pose ? this.def.getAnimations().getPoseResetId() : this.def.getAnimations().getBlankGesture()) : this.gid;
            MinecraftClientAccess.get().setEncodedGesture(id);
        }
    }

    @Override
    public boolean isCommandControlled() {
        return this.cc;
    }
}

