/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartDefinitionLink;
import com.tom.cpm.shared.parts.ModelPartEnd;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.parts.PartCollection;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ModelPartDefinition
implements IModelPart,
IResolvedModelPart,
PartCollection {
    private List<Cube> cubes;
    private List<RenderedCube> rc;
    private List<IModelPart> otherParts;
    private List<IResolvedModelPart> resolvedOtherParts;

    public ModelPartDefinition(IOHelper is, ModelDefinition def) throws IOException {
        try {
            int count = is.readVarInt();
            this.cubes = new ArrayList<Cube>();
            for (int i = 0; i < count; ++i) {
                Cube c = Cube.loadDefinitionCube(is);
                c.id = i + 10;
                this.cubes.add(c);
            }
        }
        catch (IOException e) {
            is.reset();
            int count = is.read();
            this.cubes = new ArrayList<Cube>();
            for (int i = 0; i < count; ++i) {
                Cube c = Cube.loadDefinitionCube(is);
                c.id = i + 10;
                this.cubes.add(c);
            }
        }
        this.rc = Cube.resolveCubes(this.cubes);
        this.otherParts = new ArrayList<IModelPart>();
        block8: while (true) {
            IModelPart part;
            if ((part = (IModelPart)is.readObjectBlock(ModelPartType.VALUES, (t, d) -> t.getFactory().create(d, def))) == null) {
                continue;
            }
            if (part instanceof ModelPartEnd) break;
            switch (part.getType()) {
                case DEFINITION: 
                case DEFINITION_LINK: 
                case SKIN_LINK: {
                    throw new IOException("Invalid tag in definition");
                }
                case END: {
                    continue block8;
                }
            }
            this.otherParts.add(part);
        }
    }

    public ModelPartDefinition(List<Cube> cubes) {
        this.cubes = cubes;
        this.otherParts = new ArrayList<IModelPart>();
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        this.resolvedOtherParts = new ArrayList<IResolvedModelPart>();
        for (IModelPart t : this.otherParts) {
            this.resolvedOtherParts.add(t.resolve());
        }
        return this;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeVarInt(this.cubes.size());
        ArrayList<Cube> lst = new ArrayList<Cube>(this.cubes);
        lst.sort((a, b) -> Integer.compare(a.id, b.id));
        for (Cube cube : lst) {
            Cube.saveDefinitionCube(dout, cube);
        }
        for (IModelPart part : this.otherParts) {
            dout.writeObjectBlock(part);
        }
        dout.writeObjectBlock(ModelPartEnd.END);
    }

    @Override
    public void preApply(ModelDefinition def) {
        def.addCubes(this.rc);
        this.resolvedOtherParts.forEach(p -> p.preApply(def));
    }

    @Override
    public void apply(ModelDefinition def) {
        this.resolvedOtherParts.forEach(p -> p.apply(def));
    }

    @Override
    public void stitch(TextureStitcher stitcher) {
        this.resolvedOtherParts.forEach(p -> p.stitch(stitcher));
    }

    public void setOtherParts(List<IModelPart> otherParts) {
        this.otherParts = otherParts;
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.DEFINITION;
    }

    public String toString() {
        StringBuilder bb = new StringBuilder("PartDefinition\n\tCubes: ");
        bb.append(this.cubes.size());
        bb.append("\n\tParts:");
        for (IModelPart iModelPart : this.otherParts) {
            bb.append("\n\t\t");
            bb.append(iModelPart.toString().replace("\n", "\n\t\t"));
        }
        return bb.toString();
    }

    @Override
    public void writePackage(IOHelper dout) throws IOException {
        this.write(dout);
    }

    @Override
    public IModelPart toLink(Link link) {
        return new ModelPartDefinitionLink(link);
    }

    @Override
    public void writeBlocks(IOHelper dout) throws IOException {
        dout.writeObjectBlock(this);
    }
}

