/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.render.DirectBuffer;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class BatchedBuffers<B, RT, V> {
    private List<VBuffers> buffers = new ArrayList<VBuffers>();
    private final ModelRenderManager.RedirectHolder<?, B, ?, ?> holder;
    private BiFunction<B, RT, V> getBuffer;

    public BatchedBuffers(ModelRenderManager.RedirectHolder<?, B, ?, ?> holder, BiFunction<B, RT, V> getBuffer) {
        this.holder = holder;
        this.getBuffer = getBuffer;
    }

    public VBuffers nextBatch(Supplier<BufferOutput<V>> prepBuffer, V def) {
        BufferOutput<V> out = prepBuffer.get();
        Buffer<V> db = new Buffer<V>(out, def);
        Object bs = this.holder.addDt;
        VBuffers vb = new VBuffers(rt -> new Buffer<V>(out, this.getBuffer.apply(bs, rt.getNativeType())), db).replay();
        this.buffers.add(vb);
        return vb;
    }

    public void flush() {
        this.buffers.forEach(VBuffers::finishAll);
        this.buffers.clear();
    }

    public static interface BufferOutput<V> {
        public void push(V var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13);

        default public void finish(V buf) {
        }
    }

    private static class Buffer<V>
    extends DirectBuffer<V> {
        private BufferOutput<V> out;

        public Buffer(BufferOutput<V> out, V buffer) {
            super(buffer);
            this.out = out;
        }

        @Override
        protected void pushVertex(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, float nx, float ny, float nz) {
            this.out.push(this.buffer, x, y, z, red, green, blue, alpha, u, v, nx, ny, nz);
        }

        @Override
        public void finish() {
            this.out.finish(this.buffer);
        }
    }
}

