/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.builtin;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.model.builtin.IItemModel;
import com.tom.cpm.shared.model.builtin.SimpleModel;
import com.tom.cpm.shared.model.builtin.SimplePartRenderer;

public class ShieldModel
extends SimpleModel
implements IItemModel {
    private final SimplePartRenderer plate;
    private final SimplePartRenderer handle;

    public ShieldModel() {
        this.textureWidth = 64;
        this.textureHeight = 64;
        this.plate = new SimplePartRenderer(this, 0, 0);
        this.plate.addBox(-6.0f, -11.0f, -2.0f, 12.0f, 22.0f, 1.0f, 0.0f);
        this.handle = new SimplePartRenderer(this, 26, 0);
        this.handle.addBox(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 6.0f, 0.0f);
    }

    @Override
    public void render(MatrixStack stack, VertexBuffer buf) {
        this.plate.render(stack, buf);
        this.handle.render(stack, buf);
    }

    @Override
    public String getTexture() {
        return "shield";
    }

    @Override
    public void render(MatrixStack stack, VertexBuffer buf, ItemSlot inSlot) {
        stack.push();
        float r = inSlot == ItemSlot.LEFT_HAND ? -45.0f : 45.0f;
        stack.rotate(Vec3f.POSITIVE_X.getDegreesQuaternion(50.0f));
        stack.rotate(Vec3f.POSITIVE_Y.getDegreesQuaternion(r));
        float x = inSlot == ItemSlot.LEFT_HAND ? -0.15f : 0.15f;
        stack.translate(x, 0.42f, -0.5);
        this.render(stack, buf);
        stack.pop();
    }
}

