/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.gesture;

import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.gui.gesture.AbstractGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.parts.anim.menu.BoolParameterToggleButtonData;

public class GestureToggleButton
extends AbstractGestureButton
implements IGestureButton {
    private BoolParameterToggleButtonData data;

    public GestureToggleButton(IGestureButtonContainer c, BoolParameterToggleButtonData data) {
        super(c, data, data.getName(), null);
        this.data = data;
        if (!MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            this.setEnabled(false);
            this.setTooltip(new Tooltip(this.gui.getFrame(), this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0])));
        } else {
            this.setAction(() -> {
                data.toggle();
                c.valueChanged();
            });
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        boolean on = this.data.getValue();
        int bw = this.bounds.w - 2;
        int w = this.gui.textWidth(this.name);
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        if (event.isHovered(this.bounds) && this.tooltip != null) {
            this.tooltip.set();
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, bw / 2, this.bounds.h - 2, on ? -16711936 : bgColor);
        this.gui.drawBox(this.bounds.x + 1 + bw / 2, this.bounds.y + 1, bw / 2, this.bounds.h - 2, on ? bgColor : -65536);
        this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 - 4, this.name, color);
        if (this.kb != null && this.kb.bound != null) {
            w = this.gui.textWidth(this.kb.bound);
            this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 + 4, this.kb.bound, color);
        }
    }

    @Override
    public void updateKeybinds() {
        super.updateKeybinds();
        if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            if (this.kb != null) {
                String kbMode = this.kb.mode != null ? this.gui.i18nFormat("label.cpm.gestureMode." + this.kb.mode, new Object[0]) : this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
                String boundKey = this.kb.bound;
                if (boundKey == null) {
                    boundKey = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
                }
                this.setTooltip(new Tooltip(this.gui.getFrame(), this.gui.i18nFormat("tooltip.cpm.gestureButton.mode", this.name, boundKey, kbMode)));
            } else {
                this.setTooltip(null);
            }
        }
    }
}

