/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.gesture;

import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpm.shared.gui.gesture.AbstractGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.parts.anim.menu.CustomPoseGestureButtonData;

public class CustomPoseGestureButton
extends AbstractGestureButton
implements IGestureButton {
    public CustomPoseGestureButton(IGestureButtonContainer c, CustomPoseGestureButtonData data) {
        super(c, data, data.getName(), () -> {
            data.activate();
            c.valueChanged();
        });
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        super.draw(event, partialTicks);
        int color = this.gui.getColors().button_text_color;
        if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
        }
        if (this.kb != null && this.kb.bound != null) {
            int w = this.gui.textWidth(this.kb.bound);
            this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 + 4, this.kb.bound, color);
        }
    }

    @Override
    protected boolean canHold() {
        return super.canHold();
    }

    @Override
    public void updateKeybinds() {
        super.updateKeybinds();
        if (this.kb != null) {
            String kbMode = this.kb.mode != null ? this.gui.i18nFormat("label.cpm.gestureMode." + this.kb.mode, new Object[0]) : this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
            String boundKey = this.kb.bound;
            if (boundKey == null) {
                boundKey = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
            }
            this.setTooltip(new Tooltip(this.gui.getFrame(), this.gui.i18nFormat("tooltip.cpm.gestureButton.mode", this.name, boundKey, kbMode)));
        } else {
            this.setTooltip(null);
        }
    }
}

