/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.gesture;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.gui.gesture.IGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;

public class AbstractGestureButton
extends Button
implements IGestureButton {
    protected boolean isHovered;
    private AbstractGestureButtonData data;
    protected IGestureButtonContainer.BoundKeyInfo kb;
    protected IGestureButtonContainer container;

    public AbstractGestureButton(IGestureButtonContainer c, AbstractGestureButtonData data, String name, Runnable action) {
        super(c.gui(), name, action);
        this.data = data;
        this.container = c;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.isHovered = event.isHovered(this.bounds);
        super.draw(event, partialTicks);
    }

    protected boolean canHold() {
        return true;
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (event.isHovered(this.bounds) && event.btn == 1) {
            PopupMenu p = new PopupMenu(this.gui, this.gui.getFrame());
            for (int i = 1; i <= 6; ++i) {
                String id = "qa_" + i;
                p.addButton(this.gui.i18nFormat("button.cpm.quick_key.bind", i), () -> this.container.updateKeybind(this.data.getKeybindId(), id, this.canHold() && this.gui.isCtrlDown()));
            }
            p.addButton(this.gui.i18nFormat("button.cpm.quick_key.unbind", new Object[0]), () -> {
                ConfigEntry ce = ModConfig.getCommonConfig().getEntry("keybinds");
                for (int j = 1; j <= 6; ++j) {
                    String c = ce.getString("qa_" + j, null);
                    if (c == null || !c.equals(this.data.getKeybindId())) continue;
                    ce.setString("qa_" + j, "");
                }
            });
            Vec2i pos = event.getPos();
            p.display(pos.x, pos.y);
            event.consume();
        }
        super.mouseClick(event);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        super.keyPressed(event);
        String keybindPressed = null;
        for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
            if (!kb.getName().startsWith("qa") || !kb.isPressed(event)) continue;
            keybindPressed = kb.getName();
        }
        if (keybindPressed != null) {
            this.container.updateKeybind(this.data.getKeybindId(), keybindPressed, this.canHold() && this.gui.isCtrlDown());
            event.consume();
        }
    }

    @Override
    public void updateKeybinds() {
        this.kb = this.container.getBoundKey(this.data.getKeybindId());
    }
}

