/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.tags;

import com.tom.cpl.tag.CPMTag;
import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.editor.tags.EditorTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EditorTagManager<T>
extends TagManager<T> {
    private final EditorTags allTags;

    public EditorTagManager(EditorTags allTags, TagManager<T> parent) {
        super(parent);
        this.allTags = allTags;
    }

    public EditableTag create(String id, String ... strings) {
        EditableTag tag = new EditableTag(id, Arrays.asList(strings));
        this.allTags.addTagAction(this.tags, id, tag);
        return tag;
    }

    public EditableTag load(String id, String[] strings) {
        EditableTag tag = new EditableTag(id, Arrays.asList(strings));
        this.tags.put(id, tag);
        return tag;
    }

    public EditableTag create(String id) {
        EditableTag tag = new EditableTag(id);
        this.allTags.addTagAction(this.tags, id, tag);
        return tag;
    }

    public void deleteTag(String tag) {
        this.allTags.removeTagAction(this.tags, tag);
    }

    public void addElemToTag(EditableTag tag, String elem) {
        this.allTags.addTagElemAction(tag.getEntries(), elem, () -> tag.clearCache());
    }

    public void removeElemFromTag(EditableTag tag, String elem) {
        this.allTags.removeTagElemAction(tag.getEntries(), elem, () -> tag.clearCache());
    }

    public void clear() {
        this.tags.clear();
    }

    public Collection<EditableTag> getTags() {
        return this.tags.values();
    }

    public static String formatTag(String name) {
        if (name.isEmpty()) {
            return null;
        }
        String[] strings = new String[]{"model", name};
        int i = name.indexOf(":");
        if (i >= 0) {
            strings[1] = name.substring(i + 1, name.length());
            if (i >= 1) {
                strings[0] = name.substring(0, i);
            }
        }
        if (!EditorTagManager.isValidNamespace(strings[0])) {
            return null;
        }
        if (!EditorTagManager.isValidPath(strings[1])) {
            return null;
        }
        return strings[0] + ":" + strings[1];
    }

    private static boolean isValidPath(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (EditorTagManager.validPathChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidNamespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (EditorTagManager.validNamespaceChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean validPathChar(char c) {
        return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '/' || c == '.';
    }

    private static boolean validNamespaceChar(char c) {
        return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.';
    }

    public boolean hasTags() {
        return !this.tags.isEmpty();
    }

    public Map<String, List<String>> toMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.tags.forEach((id, tag) -> map.put((String)id, (List<String>)new ArrayList<String>(tag.getEntries())));
        return map;
    }

    @Override
    protected boolean checkTag(CPMTag<T> tag) {
        return true;
    }

    public class EditableTag
    extends CPMTag<T> {
        public EditableTag(String id) {
            super(EditorTagManager.this, id, new ArrayList<String>());
        }

        public EditableTag(String id, List<String> entries) {
            super(EditorTagManager.this, id, new ArrayList<String>(entries));
        }

        private void clearCache() {
            this.stacks = null;
        }

        public String getRawId() {
            return this.id;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EditableTag other = (EditableTag)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

