/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeybindHandler;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.ListPicker;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.util.CombinedListView;
import com.tom.cpl.util.NamedElement;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.AnimationSettingsPopup;
import com.tom.cpm.shared.editor.gui.popup.ColorButton;
import com.tom.cpm.shared.editor.gui.popup.LayerDefaultPopup;
import com.tom.cpm.shared.gui.Keybinds;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AnimPanel
extends Panel {
    private Editor editor;
    private EditorGui frm;
    private ListPicker<NamedElement<EditorAnim>> animSel;
    private TabFocusHandler tabHandler;
    private Button prevFrm;
    private Button nextFrm;
    private Button clearAnimData;
    private ButtonIcon newFrmBtn;
    private AnimFrame cpyFrame;
    private AnimFrame.FrameData cpyData;

    public AnimPanel(IGui gui, final EditorGui e) {
        super(gui);
        this.tabHandler = new TabFocusHandler(gui);
        this.editor = e.getEditor();
        this.frm = e;
        this.setBounds(new Box(0, 0, 170, 330));
        this.setBackgroundColor(gui.getColors().panel_background);
        FlowLayout layout = new FlowLayout(this, 4, 1);
        NamedElement.NameMapper<EditorAnim> mapper = new NamedElement.NameMapper<EditorAnim>(new CombinedListView(Collections.singletonList(null), this.editor.animations), ea -> {
            if (ea == null) {
                return gui.i18nFormat("label.cpm.no_animation", new Object[0]);
            }
            return ea.toString();
        });
        this.animSel = new ListPicker<NamedElement<EditorAnim>>(e, mapper.asList());
        mapper.setSetter(this.animSel::setSelected);
        this.animSel.setBounds(new Box(5, 5, 160, 20));
        this.animSel.setListLoader(l -> {
            l.setComparator(mapper.cmp(Comparator.comparing(a -> a == null ? null : "", Comparator.nullsFirst(Comparator.naturalOrder()))).thenComparing(mapper.cmp(Comparator.comparing(AnimPanel::getPose0, Comparator.nullsLast(Comparator.naturalOrder())))).thenComparing(mapper.cmp(Comparator.comparing(AnimPanel::getPose1, Comparator.nullsLast(Comparator.naturalOrder())))).thenComparing(Comparator.comparing(NamedElement::toString)));
            l.setGetTooltip(n -> n.getElem() == null ? null : new Tooltip(e, ((EditorAnim)n.getElem()).toString()));
        });
        this.animSel.setAction(() -> {
            this.editor.selectedAnim = this.animSel.getSelected().getElem();
            this.editor.updateGui();
        });
        this.editor.setSelAnim.add(v -> {
            mapper.refreshValues();
            mapper.setValue((EditorAnim)v);
        });
        Panel p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 25));
        p.addElement(this.animSel);
        this.addElement(p);
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 20));
        this.addElement(p);
        ButtonIcon newAnimBtn = new ButtonIcon(gui, "editor", 0, 16, () -> e.openPopup(new AnimationSettingsPopup(gui, this.editor, false)));
        newAnimBtn.setBounds(new Box(5, 0, 20, 20));
        p.addElement(newAnimBtn);
        ButtonIcon delAnimBtn = new ButtonIcon(gui, "editor", 16, 16, ConfirmPopup.confirmHandler(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), this.editor::delSelectedAnim));
        delAnimBtn.setBounds(new Box(30, 0, 20, 20));
        p.addElement(delAnimBtn);
        this.editor.setAnimDelEn.add(delAnimBtn::setEnabled);
        Button editBtn = new Button(gui, gui.i18nFormat("button.cpm.edit", new Object[0]), () -> e.openPopup(new AnimationSettingsPopup(gui, this.editor, true)));
        editBtn.setBounds(new Box(55, 0, 80, 20));
        p.addElement(editBtn);
        this.editor.setAnimDelEn.add(editBtn::setEnabled);
        Button optBtn = new Button(gui, "...", null){

            @Override
            public void mouseClick(MouseEvent evt) {
                if (evt.isHovered(this.bounds)) {
                    Vec2i p = evt.getPos();
                    PopupMenu animPopup = new PopupMenu(this.gui, e);
                    if (((AnimPanel)AnimPanel.this).editor.selectedAnim != null) {
                        animPopup.addButton(this.gui.i18nFormat("button.cpm.dupAnim", new Object[0]), () -> {
                            EditorAnim cpy = new EditorAnim(((AnimPanel)AnimPanel.this).editor.selectedAnim);
                            AnimPanel.this.editor.action("add", "action.cpm.anim").addToList(((AnimPanel)AnimPanel.this).editor.animations, cpy).onUndo(() -> {
                                ((AnimPanel)AnimPanel.this).editor.selectedAnim = null;
                            }).execute();
                            ((AnimPanel)AnimPanel.this).editor.selectedAnim = cpy;
                            AnimPanel.this.editor.updateGui();
                        });
                        AnimPanel this0 = AnimPanel.this;
                        animPopup.addButton(this.gui.i18nFormat("button.cpm.copyAnimFrame", new Object[0]), () -> this0.copyFrame()).setTooltip(new Tooltip((Frame)e, this.gui.i18nFormat("tooltip.cpm.anim.copyFrame", new Object[0]), Keybinds.COPY_ANIM_FRAME));
                        if (AnimPanel.this.cpyFrame != null) {
                            animPopup.addButton(this.gui.i18nFormat("button.cpm.pasteAnimFrame", new Object[0]), () -> this0.pasteFrame()).setTooltip(new Tooltip((Frame)e, this.gui.i18nFormat("tooltip.cpm.anim.pasteFrame", new Object[0]), Keybinds.PASTE_ANIM_FRAME));
                        }
                        if (AnimPanel.this.editor.getSelectedElement() != null) {
                            animPopup.addButton(this.gui.i18nFormat("button.cpm.copyAnimFrameData", new Object[0]), () -> this0.copyData()).setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.anim.copyData", Keybinds.COPY_ANIM_PART)));
                            if (AnimPanel.this.cpyData != null) {
                                animPopup.addButton(this.gui.i18nFormat("button.cpm.pasteAnimFrameData", new Object[0]), () -> this0.pasteData()).setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.anim.pasteData", Keybinds.PASTE_ANIM_PART)));
                                animPopup.addButton(this.gui.i18nFormat("button.cpm.pasteAnimFrameDataAll", new Object[0]), () -> this0.pasteDataAll()).setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.anim.pasteDataAll", new Object[0])));
                            }
                            animPopup.addButton(this.gui.i18nFormat("button.cpm.mirrorFrameData", new Object[0]), () -> this0.mirrorData()).setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.anim.mirrorFrameData", new Object[0])));
                        }
                        animPopup.addButton(this.gui.i18nFormat("button.cpm.reverseAnimation", new Object[0]), () -> this0.reverseAnim()).setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.anim.reverseAnimation", new Object[0])));
                        animPopup.addButton(this.gui.i18nFormat("button.cpm.clearFrame", new Object[0]), () -> this0.clearFrame()).setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.anim.clearFrame", new Object[0])));
                    }
                    if (animPopup.getY() != 0) {
                        animPopup.display(p.x - evt.x + this.bounds.x / 2, p.y - evt.y + this.bounds.h + this.bounds.y, 160);
                    }
                    evt.consume();
                }
            }
        };
        optBtn.setBounds(new Box(140, 0, 25, 20));
        this.editor.setAnimDelEn.add(optBtn::setEnabled);
        p.addElement(optBtn);
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 20));
        this.addElement(p);
        Label currFrame = new Label(gui, "");
        currFrame.setBounds(new Box(30, 5, 110, 10));
        p.addElement(currFrame);
        this.prevFrm = new Button(gui, "<", () -> {
            if (gui.isCtrlDown()) {
                this.editor.animMoveFrame(-1);
            } else {
                this.editor.animPrevFrm();
            }
        });
        this.prevFrm.setBounds(new Box(5, 0, 20, 20));
        p.addElement(this.prevFrm);
        this.nextFrm = new Button(gui, ">", () -> {
            if (gui.isCtrlDown()) {
                this.editor.animMoveFrame(1);
            } else {
                this.editor.animNextFrm();
            }
        });
        this.nextFrm.setBounds(new Box(145, 0, 20, 20));
        p.addElement(this.nextFrm);
        this.editor.setAnimFrame.add(i -> {
            this.prevFrm.setEnabled(i != null);
            this.nextFrm.setEnabled(i != null);
            if (i != null) {
                currFrame.setText(gui.i18nFormat("label.cpm.anim_frame_x", i + 1));
            } else {
                currFrame.setText(gui.i18nFormat("label.cpm.anim_frame_none", new Object[0]));
            }
        });
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 20));
        this.addElement(p);
        this.newFrmBtn = new ButtonIcon(gui, "editor", 0, 16, this::newFrame);
        this.newFrmBtn.setBounds(new Box(5, 0, 20, 20));
        this.newFrmBtn.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.anim.newFrame", new Object[0])));
        p.addElement(this.newFrmBtn);
        this.editor.setFrameAddEn.add(this.newFrmBtn::setEnabled);
        ButtonIcon delFrmBtn = new ButtonIcon(gui, "editor", 16, 16, ConfirmPopup.confirmHandler(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), this.editor::delSelectedAnimFrame));
        delFrmBtn.setBounds(new Box(30, 0, 20, 20));
        p.addElement(delFrmBtn);
        this.editor.setFrameDelEn.add(delFrmBtn::setEnabled);
        ButtonIcon playBtn = new ButtonIcon(gui, "editor", 64, 16, true, () -> {
            this.editor.playFullAnim = !this.editor.playFullAnim;
            this.editor.playStartTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
            this.editor.setAnimPlay.accept(this.editor.playFullAnim);
        });
        playBtn.setBounds(new Box(55, 0, 20, 20));
        p.addElement(playBtn);
        this.editor.setAnimPlayEn.add(playBtn::setEnabled);
        this.editor.setAnimPlay.add(v -> playBtn.setU(v != false ? 80 : 64));
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 30));
        this.addElement(p);
        Label lblDuration = new Label(gui, gui.i18nFormat("label.cpm.duration", new Object[0]));
        lblDuration.setBounds(new Box(5, 0, 0, 0));
        p.addElement(lblDuration);
        Spinner duration = new Spinner(gui);
        duration.setDp(0);
        duration.setBounds(new Box(5, 10, 100, 20));
        p.addElement(duration);
        this.editor.setAnimDuration.add(i -> {
            duration.setEnabled(i != null);
            if (i != null) {
                duration.setValue(i.intValue());
            } else {
                duration.setValue(1000.0f);
            }
        });
        duration.addChangeListener(() -> this.editor.setAnimDuration((int)duration.getValue()));
        this.tabHandler.add(duration);
        this.clearAnimData = new Button(gui, gui.i18nFormat("button.cpm.clearAnimData", new Object[0]), () -> {
            boolean all = gui.isCtrlDown();
            ConfirmPopup.confirm(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> this.editor.delSelectedAnimPartData(all));
        });
        this.clearAnimData.setBounds(new Box(110, 10, 55, 18));
        this.clearAnimData.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.clearAnimData", new Object[0])));
        p.addElement(this.clearAnimData);
        PosPanel.addVec3("rotation", v -> this.editor.setAnimRot((Vec3f)v), this, this.editor.setAnimRot, 1, this.tabHandler);
        PosPanel.addVec3("position", v -> this.editor.setAnimPos((Vec3f)v), this, this.editor.setAnimPos, 2, this.tabHandler);
        PosPanel.addVec3("render_scale", v -> this.editor.setAnimScale((Vec3f)v), this, this.editor.setAnimScale, 2, this.tabHandler);
        this.editor.updateGui.add(() -> {
            this.clearAnimData.setEnabled(this.editor.getSelectedElement() != null && this.editor.selectedAnim != null && this.editor.selectedAnim.getSelectedFrame() != null);
            layout.reflow();
        });
        ColorButton colorBtn = new ColorButton(gui, e, this.editor::setAnimColor);
        colorBtn.setBounds(new Box(5, 0, 140, 20));
        this.editor.setAnimColor.add(c -> {
            colorBtn.setEnabled(c != null);
            if (c != null) {
                colorBtn.setColor((int)c);
            } else {
                colorBtn.setColor(0);
            }
        });
        this.addElement(colorBtn);
        Checkbox boxShow = new Checkbox(gui, gui.i18nFormat("label.cpm.visible", new Object[0]));
        boxShow.setBounds(new Box(5, 0, 60, 20));
        boxShow.setAction(this.editor::switchAnimShow);
        this.editor.setAnimShow.add(boxShow::updateState);
        this.addElement(boxShow);
        Button encSettings = new Button(gui, gui.i18nFormat("button.cpm.animEncSettings", new Object[0]), () -> e.openPopup(new AnimEncConfigPopup(gui, this.editor, null)));
        encSettings.setBounds(new Box(5, 0, 155, 20));
        this.addElement(encSettings);
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 30));
        this.addElement(p);
        Label lblPri = new Label(gui, gui.i18nFormat("label.cpm.anim_priority", new Object[0]));
        lblPri.setBounds(new Box(5, 0, 160, 10));
        lblPri.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.anim_priority", new Object[0])));
        p.addElement(lblPri);
        Spinner animPriority = new Spinner(gui);
        this.editor.setAnimPriority.add(v -> {
            animPriority.setEnabled(v != null);
            if (v != null) {
                animPriority.setValue(v.intValue());
            } else {
                animPriority.setValue(0.0f);
            }
        });
        animPriority.setBounds(new Box(5, 10, 100, 20));
        animPriority.setDp(0);
        animPriority.addChangeListener(() -> this.editor.setAnimPriority((int)animPriority.getValue()));
        p.addElement(animPriority);
        this.tabHandler.add(animPriority);
        Button defLayerSettings = new Button(gui, gui.i18nFormat("button.cpm.defLayerSettings", new Object[0]), () -> {
            if (this.editor.selectedAnim != null) {
                if (this.editor.selectedAnim.type == AnimationType.LAYER) {
                    e.openPopup(new LayerDefaultPopup.Toggle(gui, this.editor));
                } else if (this.editor.selectedAnim.type == AnimationType.VALUE_LAYER) {
                    e.openPopup(new LayerDefaultPopup.Value(gui, this.editor));
                }
            }
        });
        defLayerSettings.setBounds(new Box(5, 0, 155, 20));
        this.addElement(defLayerSettings);
        this.editor.updateGui.add(() -> defLayerSettings.setEnabled(this.editor.selectedAnim != null && this.editor.selectedAnim.isLayer()));
        p = new Panel(gui);
        p.setBounds(new Box(0, 0, this.bounds.w, 30));
        this.addElement(p);
        Label lblOrder = new Label(gui, gui.i18nFormat("label.cpm.anim_order", new Object[0]));
        lblOrder.setBounds(new Box(5, 0, 160, 10));
        lblOrder.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.anim_order", new Object[0])));
        p.addElement(lblOrder);
        Spinner animOrder = new Spinner(gui);
        this.editor.setAnimOrder.add(v -> {
            animOrder.setEnabled(v != null);
            if (v != null) {
                animOrder.setValue(v.intValue());
            } else {
                animOrder.setValue(0.0f);
            }
        });
        animOrder.setBounds(new Box(5, 10, 100, 20));
        animOrder.setDp(0);
        animOrder.addChangeListener(() -> this.editor.setAnimOrder((int)animOrder.getValue()));
        p.addElement(animOrder);
        this.tabHandler.add(animOrder);
        this.editor.updateGui.add(() -> animOrder.setEnabled(this.editor.selectedAnim != null && this.editor.selectedAnim.isCustom() && !this.editor.selectedAnim.type.isStaged()));
        layout.reflow();
        this.addElement(this.tabHandler);
    }

    private void copyFrame() {
        if (this.editor.selectedAnim != null) {
            this.cpyFrame = new AnimFrame(this.editor.selectedAnim.getSelectedFrame());
        }
    }

    private void pasteFrame() {
        if (this.editor.selectedAnim != null && this.cpyFrame != null) {
            this.editor.selectedAnim.addFrame(this.cpyFrame);
            this.cpyFrame = null;
            this.editor.updateGui();
        }
    }

    private void copyData() {
        ModelElement me = this.editor.getSelectedElement();
        if (this.editor.selectedAnim != null && me != null) {
            this.cpyData = this.editor.selectedAnim.getSelectedFrame().copy(me);
        }
    }

    private void pasteData() {
        ModelElement me = this.editor.getSelectedElement();
        if (this.editor.selectedAnim != null && this.cpyData != null && me != null) {
            ActionBuilder ab = this.editor.action("setAnim", "action.cpm.value");
            this.editor.selectedAnim.getSelectedFrame().importFrameData(ab, me, this.cpyData);
            ab.onAction(this.editor.selectedAnim::clearCache);
            ab.execute();
            this.editor.updateGui();
        }
    }

    private void pasteDataAll() {
        ModelElement me = this.editor.getSelectedElement();
        if (this.editor.selectedAnim != null && this.cpyData != null && me != null) {
            ActionBuilder ab = this.editor.action("setAnim", "action.cpm.value");
            this.editor.selectedAnim.getFrames().forEach(f -> f.importFrameData(ab, me, this.cpyData));
            ab.onAction(this.editor.selectedAnim::clearCache);
            ab.execute();
            this.editor.updateGui();
        }
    }

    private void mirrorData() {
        AnimFrame.FrameData d;
        ModelElement me = this.editor.getSelectedElement();
        if (this.editor.selectedAnim != null && me != null && (d = this.editor.selectedAnim.getSelectedFrame().getComponents().get(me)) != null) {
            ActionBuilder ab = this.editor.action("i", "button.cpm.tools.mirror");
            d.mirror(ab);
            ab.onAction(this.editor.selectedAnim::clearCache);
            ab.execute();
        }
    }

    private void reverseAnim() {
        if (this.editor.selectedAnim != null) {
            ActionBuilder ab = this.editor.action("i", "button.cpm.reverseAnimation");
            this.editor.selectedAnim.reverseFrameOrder(ab);
            ab.execute();
        }
    }

    private void clearFrame() {
        if (this.editor.selectedAnim != null) {
            ActionBuilder ab = this.editor.action("i", "button.cpm.clearFrame");
            Map<ModelElement, AnimFrame.FrameData> comp = this.editor.selectedAnim.getSelectedFrame().getComponents();
            HashMap<ModelElement, AnimFrame.FrameData> bck = new HashMap<ModelElement, AnimFrame.FrameData>(comp);
            ab.onRun(() -> comp.clear());
            ab.onUndo(() -> comp.putAll(bck));
            ab.onAction(this.editor.selectedAnim::clearCache);
            ab.execute();
        }
    }

    private void newFrame() {
        this.editor.addNewAnimFrame(!this.gui.isShiftDown());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.editor.playFullAnim = false;
            this.editor.selectedAnim = this.animSel.getSelected().getElem();
            this.editor.setAnimPlay.accept(false);
            this.editor.updateGui();
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        if (this.gui.isCtrlDown()) {
            this.prevFrm.setText("<<");
            this.nextFrm.setText(">>");
            this.clearAnimData.setText(this.gui.i18nFormat("button.cpm.clearAnimDataAll", new Object[0]));
        } else {
            this.prevFrm.setText("<");
            this.nextFrm.setText(">");
            this.clearAnimData.setText(this.gui.i18nFormat("button.cpm.clearAnimData", new Object[0]));
        }
        if (this.gui.isShiftDown()) {
            this.newFrmBtn.setU(96);
        } else {
            this.newFrmBtn.setU(0);
        }
        super.draw(event, partialTicks);
    }

    private static VanillaPose getPose0(EditorAnim ea) {
        if (ea == null) {
            return null;
        }
        IPose pose = ea.getPose();
        if (pose == null || !(pose instanceof VanillaPose)) {
            return null;
        }
        return (VanillaPose)pose;
    }

    private static String getPose1(EditorAnim ea) {
        if (ea == null) {
            return null;
        }
        IPose pose = ea.getPose();
        if (pose == null || !(pose instanceof CustomPose)) {
            return null;
        }
        return ((CustomPose)pose).getName();
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        KeybindHandler h = this.frm.getKeybindHandler();
        h.registerKeybind(Keybinds.COPY_ANIM_FRAME, this::copyFrame);
        h.registerKeybind(Keybinds.PASTE_ANIM_FRAME, this::pasteFrame);
        h.registerKeybind(Keybinds.COPY_ANIM_PART, this::copyData);
        h.registerKeybind(Keybinds.PASTE_ANIM_PART, this::pasteData);
        h.registerKeybind(Keybinds.ANIM_PREV_FRAME, this.editor::animPrevFrm);
        h.registerKeybind(Keybinds.ANIM_NEXT_FRAME, this.editor::animNextFrm);
        h.registerKeybind(Keybinds.ANIM_NEW_FRAME, this::newFrame);
        super.keyPressed(event);
    }
}

