/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.text.I18n;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.project.JsonMap;
import java.util.HashMap;
import java.util.Map;

public class CopyTransformEffect {
    public final ModelElement to;
    public long storeID;
    public ModelElement from;
    public boolean copyPX;
    public boolean copyPY;
    public boolean copyPZ;
    public boolean copyRX;
    public boolean copyRY;
    public boolean copyRZ;
    public boolean copySX;
    public boolean copySY;
    public boolean copySZ;
    public boolean copyVis;

    public CopyTransformEffect(ModelElement to) {
        this.to = to;
    }

    public void load(JsonMap data) {
        this.storeID = data.getLong("storeID", -1L);
        this.copyPX = data.getBoolean("px", false);
        this.copyPY = data.getBoolean("py", false);
        this.copyPZ = data.getBoolean("pz", false);
        this.copyRX = data.getBoolean("rx", false);
        this.copyRY = data.getBoolean("ry", false);
        this.copyRZ = data.getBoolean("rz", false);
        this.copySX = data.getBoolean("sx", false);
        this.copySY = data.getBoolean("sy", false);
        this.copySZ = data.getBoolean("sz", false);
        this.copyVis = data.getBoolean("cv", false);
    }

    public short toShort() {
        short r = 0;
        if (this.copyPX) {
            r = (short)(r | 1);
        }
        if (this.copyPY) {
            r = (short)(r | 2);
        }
        if (this.copyPZ) {
            r = (short)(r | 4);
        }
        if (this.copyRX) {
            r = (short)(r | 8);
        }
        if (this.copyRY) {
            r = (short)(r | 0x10);
        }
        if (this.copyRZ) {
            r = (short)(r | 0x20);
        }
        if (this.copySX) {
            r = (short)(r | 0x40);
        }
        if (this.copySY) {
            r = (short)(r | 0x80);
        }
        if (this.copySZ) {
            r = (short)(r | 0x100);
        }
        if (this.copyVis) {
            r = (short)(r | 0x200);
        }
        return r;
    }

    public void apply() {
        if (this.from != null) {
            this.to.rc.setPosition(false, this.copyPX ? this.from.rc.getTransformPosition().x : this.to.rc.getTransformPosition().x, this.copyPY ? this.from.rc.getTransformPosition().y : this.to.rc.getTransformPosition().y, this.copyPZ ? this.from.rc.getTransformPosition().z : this.to.rc.getTransformPosition().z);
            this.to.rc.setRotation(false, this.copyRX ? this.from.rc.getTransformRotation().x : this.to.rc.getTransformRotation().x, this.copyRY ? this.from.rc.getTransformRotation().y : this.to.rc.getTransformRotation().y, this.copyRZ ? this.from.rc.getTransformRotation().z : this.to.rc.getTransformRotation().z);
            this.to.rc.setRenderScale(false, this.copySX ? this.from.rc.getRenderScale().x : this.to.rc.getRenderScale().x, this.copySY ? this.from.rc.getRenderScale().y : this.to.rc.getRenderScale().y, this.copySZ ? this.from.rc.getRenderScale().z : this.to.rc.getRenderScale().z);
            if (this.copyVis) {
                this.to.rc.setVisible(this.to.rc.doDisplay() && this.from.rc.isVisible());
            }
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (this.from != null) {
            r.put("storeID", this.from.storeID);
        }
        r.put("px", this.copyPX);
        r.put("py", this.copyPY);
        r.put("pz", this.copyPZ);
        r.put("rx", this.copyRX);
        r.put("ry", this.copyRY);
        r.put("rz", this.copyRZ);
        r.put("sx", this.copySX);
        r.put("sy", this.copySY);
        r.put("sz", this.copySZ);
        r.put("cv", this.copyVis);
        return r;
    }

    public void load(Editor editor) {
        Editor.walkElements(editor.elements, elem -> {
            if (elem.storeID == this.storeID) {
                this.from = elem;
            }
        });
    }

    public String getTooltip(I18n gui) {
        StringBuilder sb = new StringBuilder();
        sb.append(gui.i18nFormat("label.cpm.copyTransform", new Object[0]));
        if (this.from != null) {
            sb.append("\\ ");
            sb.append(gui.i18nFormat("label.cpm.copyTransform.from", this.from.getElemName()));
        }
        boolean p = this.createXYZ(sb, gui.i18nFormat("label.cpm.position", new Object[0]), this.copyPX, this.copyPY, this.copyPZ);
        boolean r = this.createXYZ(sb, gui.i18nFormat("label.cpm.rotation", new Object[0]), this.copyRX, this.copyRY, this.copyRZ);
        boolean s = this.createXYZ(sb, gui.i18nFormat("label.cpm.scale", new Object[0]), this.copySX, this.copySY, this.copySZ);
        if (this.copyVis) {
            sb.append("\\  ");
            sb.append(gui.i18nFormat("label.cpm.visible", new Object[0]));
        }
        if (!(p || r || s || this.copyVis)) {
            sb.append("\\  ");
            sb.append(gui.i18nFormat("tooltip.cpm.noCopyTransforms", new Object[0]));
        }
        return sb.toString();
    }

    private boolean createXYZ(StringBuilder sb, String name, boolean x, boolean y, boolean z) {
        if (x || y || z) {
            sb.append("\\  ");
            sb.append(name);
            sb.append(": ");
            if (x) {
                sb.append('X');
            }
            if (y && x) {
                sb.append(", Y");
            } else if (y) {
                sb.append('Y');
            }
            if (z && (x || y)) {
                sb.append(", Z");
            } else if (z) {
                sb.append('Z');
            }
            return true;
        }
        return false;
    }

    public void setAll(boolean v) {
        this.copyPX = v;
        this.copyPY = v;
        this.copyPZ = v;
        this.copyRX = v;
        this.copyRY = v;
        this.copyRZ = v;
        this.copySX = v;
        this.copySY = v;
        this.copySZ = v;
        this.copyVis = v;
    }
}

