/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.definition;

import com.google.common.util.concurrent.UncheckedExecutionException;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpl.tag.IAllTags;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpl.util.LocalizedException;
import com.tom.cpl.util.StringBuilderStream;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.IModelComponent;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.definition.VanillaDefinition;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PartPosition;
import com.tom.cpm.shared.model.PartRoot;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.PlayerPartValues;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.ScaleData;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.BoxRender;
import com.tom.cpm.shared.model.render.ItemRenderer;
import com.tom.cpm.shared.model.render.ItemTransform;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartCloneable;
import com.tom.cpm.shared.parts.ModelPartCollection;
import com.tom.cpm.shared.parts.ModelPartDefinition;
import com.tom.cpm.shared.parts.ModelPartDefinitionLink;
import com.tom.cpm.shared.parts.ModelPartLink;
import com.tom.cpm.shared.parts.ModelPartSkin;
import com.tom.cpm.shared.parts.ModelPartSkinLink;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ModelDefinition {
    private final ModelDefinitionLoader<?> loader;
    private final Player<?> playerObj;
    private List<IModelPart> parts;
    private List<IResolvedModelPart> resolved;
    protected List<RenderedCube> cubes;
    private Map<Integer, RenderedCube> cubeMap;
    private Map<TextureSheetType, TextureProvider> textures;
    private TextureProvider skinTexture;
    public Map<ItemRenderer, ItemTransform> itemTransforms = new HashMap<ItemRenderer, ItemTransform>();
    protected Map<VanillaModelPart, PartRoot> rootRenderingCubes;
    protected ModelLoadingState resolveState = ModelLoadingState.NEW;
    private AnimationRegistry animations = new AnimationRegistry();
    private ScaleData scale;
    public PartPosition fpLeftHand;
    public PartPosition fpRightHand;
    private boolean stitchedTexture;
    public boolean hideHeadIfSkull = true;
    public boolean removeArmorOffset;
    public boolean removeBedOffset;
    public boolean enableInvisGlow;
    public ModelPartCloneable cloneable;
    private Throwable error;
    public IAllTags modelTagManager;

    public ModelDefinition(ModelDefinitionLoader<?> loader, Player<?> player) {
        this.loader = loader;
        this.playerObj = player;
        this.modelTagManager = new AllTagManagers(MinecraftClientAccess.get().getBuiltinTags());
    }

    public ModelDefinition(Throwable e, Player<?> player) {
        this.loader = null;
        this.playerObj = player;
        this.modelTagManager = new AllTagManagers(MinecraftClientAccess.get().getBuiltinTags());
        this.setError(e);
    }

    public ModelDefinition setParts(List<IModelPart> parts) {
        this.parts = parts;
        return this;
    }

    protected ModelDefinition() {
        this.loader = null;
        this.resolveState = ModelLoadingState.LOADED;
        this.playerObj = null;
    }

    public void startResolve() {
        this.resolveState = ModelLoadingState.RESOLVING;
        ModelDefinitionLoader.THREAD_POOL.execute(() -> {
            try {
                this.resolveAll();
            }
            catch (Throwable e) {
                this.setError(e);
            }
        });
    }

    public void validate() {
        if (this.loader == null) {
            return;
        }
        boolean hasSkin = false;
        boolean hasDef = false;
        for (IModelPart iModelPart : this.parts) {
            if (iModelPart instanceof ModelPartSkin || iModelPart instanceof ModelPartSkinLink) {
                if (hasSkin) {
                    throw new IllegalStateException("Multiple skin tags");
                }
                hasSkin = true;
            }
            if (!(iModelPart instanceof ModelPartDefinition) && !(iModelPart instanceof ModelPartDefinitionLink)) continue;
            if (hasDef) {
                throw new IllegalStateException("Multiple definition tags");
            }
            hasDef = true;
        }
    }

    public void resolveAll() throws IOException {
        if (this.loader == null) {
            return;
        }
        this.resolved = new ArrayList<IResolvedModelPart>();
        for (IModelPart part : this.parts) {
            this.resolved.add(part.resolve());
        }
        this.textures = new HashMap<TextureSheetType, TextureProvider>();
        this.cubes = new ArrayList<RenderedCube>();
        this.rootRenderingCubes = new HashMap<VanillaModelPart, PartRoot>();
        HashMap<Integer, RootModelElement> playerModelParts = new HashMap<Integer, RootModelElement>();
        for (int i = 0; i < PlayerModelParts.VALUES.length; ++i) {
            RootModelElement rootModelElement = new RootModelElement(PlayerModelParts.VALUES[i], this);
            this.rootRenderingCubes.put(PlayerModelParts.VALUES[i], new PartRoot(rootModelElement));
            playerModelParts.put(i, rootModelElement);
        }
        this.resolved.forEach(r -> r.preApply(this));
        for (RenderedCube renderedCube : this.cubes) {
            int id = renderedCube.getCube().parentId;
            RenderedCube p = (RenderedCube)playerModelParts.get(id);
            if (p != null) {
                p.addChild(renderedCube);
                renderedCube.setParent(p);
            }
            if (renderedCube.getParent() != null) continue;
            throw new IOException("Cube without parent");
        }
        int cc = this.cubes.size();
        for (RenderedCube rc : this.cubes) {
            if (!rc.extrude) continue;
            cc += BoxRender.getExtrudeSize(rc.getCube().size, rc.getCube().texSize);
        }
        ConfigKeys.MAX_CUBE_COUNT.checkFor(this.playerObj, cc, SafetyException.BlockReason.TOO_MANY_CUBES);
        TextureStitcher textureStitcher = new TextureStitcher(this.playerObj.isClientPlayer() ? 8192 : ConfigKeys.MAX_TEX_SHEET_SIZE.getValueFor(this.playerObj));
        if (this.textures.containsKey((Object)TextureSheetType.SKIN)) {
            textureStitcher.setBase(this.textures.get((Object)TextureSheetType.SKIN));
            this.skinTexture = this.textures.get((Object)TextureSheetType.SKIN);
        } else {
            Image skin;
            try {
                skin = this.playerObj.getTextures().getTexture(TextureType.SKIN).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e1) {
                throw new IOException(e1);
            }
            if (skin == null) {
                skin = this.playerObj.getSkinType().getSkinTexture();
            }
            textureStitcher.setBase(skin);
            this.skinTexture = new TextureProvider(skin, new Vec2i(64, 64));
        }
        this.resolved.forEach(r -> r.stitch(stitcher));
        TextureProvider tx = textureStitcher.finish();
        if (tx != null) {
            this.textures.put(TextureSheetType.SKIN, tx);
            this.skinTexture = tx;
        }
        this.stitchedTexture = textureStitcher.hasStitches();
        if (this.stitchedTexture) {
            for (PlayerModelParts part : PlayerModelParts.VALUES) {
                if (part == PlayerModelParts.CUSTOM_PART) continue;
                this.convertPart((RootModelElement)playerModelParts.get(part.ordinal()));
            }
        }
        this.cubeMap = new HashMap<Integer, RenderedCube>();
        this.cubes.addAll(playerModelParts.values());
        this.cubes.forEach(c -> this.cubeMap.put(c.getId(), (RenderedCube)c));
        this.resolved.forEach(r -> r.apply(this));
        this.resetAnimationPos();
        this.resolveState = ModelLoadingState.LOADED;
        Log.debug(this);
    }

    protected void convertPart(RootModelElement p) {
        PlayerModelParts part = (PlayerModelParts)p.getPart();
        if (!p.isHidden()) {
            p.setHidden(true);
            Cube cube = new Cube();
            PlayerPartValues val = PlayerPartValues.getFor(part, this.playerObj.getSkinType());
            cube.offset = val.getOffset();
            cube.rotation = new Vec3f(0.0f, 0.0f, 0.0f);
            cube.pos = new Vec3f(0.0f, 0.0f, 0.0f);
            cube.size = val.getSize();
            cube.scale = new Vec3f(1.0f, 1.0f, 1.0f);
            cube.meshScale = new Vec3f(1.0f, 1.0f, 1.0f);
            cube.u = val.u;
            cube.v = val.v;
            cube.texSize = 1;
            cube.id = 65520 + part.ordinal();
            RenderedCube rc = new RenderedCube(cube);
            rc.setParent(p);
            p.addChild(rc);
        }
    }

    public void cleanup() {
        this.resolveState = ModelLoadingState.CLEANED_UP;
        if (this.loader == null) {
            return;
        }
        if (this.cubes != null) {
            this.cubes.forEach(c -> {
                if (c.renderObject != null) {
                    c.renderObject.free();
                }
                c.renderObject = null;
            });
        }
        if (this.textures != null) {
            this.textures.values().forEach(TextureProvider::free);
        }
        this.cubes = null;
        this.textures = null;
    }

    public boolean doRender() {
        return this.loader != null && this.resolveState == ModelLoadingState.LOADED;
    }

    public ModelLoadingState getResolveState() {
        return this.resolveState;
    }

    public PartRoot getModelElementFor(VanillaModelPart part) {
        return this.rootRenderingCubes.get(part);
    }

    public boolean isEditor() {
        return false;
    }

    public AnimationRegistry getAnimations() {
        return this.animations;
    }

    public Player<?> getPlayerObj() {
        return this.playerObj;
    }

    public RenderedCube getElementById(int id) {
        return this.cubeMap.get(id);
    }

    public void resetAnimationPos() {
        this.cubes.forEach(IModelComponent::reset);
    }

    public String toString() {
        StringBuilder bb = new StringBuilder("ModelDefinition\n\tResolved: ");
        bb.append((Object)this.resolveState);
        switch (this.resolveState) {
            case NEW: 
            case RESOLVING: {
                bb.append("\n\tParts:");
                for (IModelPart iModelPart : this.parts) {
                    bb.append("\n\t\t");
                    bb.append(iModelPart.toString().replace("\n", "\n\t\t"));
                }
                break;
            }
            case LOADED: {
                bb.append("\n\tCubes: ");
                bb.append(this.cubes.size());
                bb.append("\n\tOther:");
                for (IResolvedModelPart iModelPart : this.resolved) {
                    bb.append("\n\t\t");
                    bb.append(iModelPart.toString().replace("\n", "\n\t\t"));
                }
                break;
            }
            case ERRORRED: 
            case SAFETY_BLOCKED: {
                bb.append("\n\t\t");
                StringBuilderStream.stacktraceToString(this.error, bb, "\n\t\t");
                if (this.error instanceof SafetyException) {
                    bb.append((Object)((SafetyException)this.error).getBlockReason());
                    break;
                }
                bb.append("Unexpected error");
                break;
            }
        }
        return bb.toString();
    }

    public RootModelElement addRoot(int baseID, VanillaModelPart type) {
        RootModelElement elem = new RootModelElement(type, this);
        elem.children = new ArrayList();
        this.rootRenderingCubes.computeIfAbsent(type, k -> new PartRoot(elem)).add(elem);
        this.cubes.add(elem);
        this.cubeMap.put(baseID, elem);
        if (type instanceof PlayerModelParts && this.stitchedTexture) {
            this.convertPart(elem);
        }
        return elem;
    }

    public TextureProvider getTexture(TextureSheetType key, boolean inGui) {
        if (key == TextureSheetType.SKIN && inGui) {
            return this.skinTexture;
        }
        return key.editable ? (this.textures == null ? null : this.textures.get((Object)key)) : null;
    }

    public void setTexture(TextureSheetType key, TextureProvider value) {
        this.textures.put(key, value);
    }

    public ModelPartLink findDefLink() {
        for (IModelPart iModelPart : this.parts) {
            if (!(iModelPart instanceof ModelPartDefinitionLink) && !(iModelPart instanceof ModelPartCollection.PackageLink)) continue;
            return (ModelPartLink)iModelPart;
        }
        return null;
    }

    public boolean isStitchedTexture() {
        return this.stitchedTexture;
    }

    public SkinType getSkinType() {
        return this.playerObj.getSkinType();
    }

    public void setScale(ScaleData scale) {
        this.scale = scale;
    }

    public ScaleData getScale() {
        return this.scale;
    }

    public static ModelDefinition createVanilla(Supplier<TextureProvider> texture, SkinType type) {
        return new VanillaDefinition(texture, type);
    }

    public boolean hasRoot(VanillaModelPart type) {
        return this.rootRenderingCubes.containsKey(type);
    }

    public ModelDefinitionLoader<?> getLoader() {
        return this.loader;
    }

    public <V> void check(PlayerSpecificConfigKey<V> key, Predicate<V> check, SafetyException.BlockReason err) throws SafetyException {
        key.checkFor(this.playerObj, check, err);
    }

    public ItemTransform getTransform(ItemSlot slot) {
        return this.itemTransforms.keySet().stream().filter(s -> s.slot == slot).findFirst().map(this::getTransform).orElse(null);
    }

    public ItemTransform getTransform(ItemRenderer slot) {
        return this.itemTransforms.get(slot);
    }

    public void storeTransform(ItemRenderer render, MatrixStack stack, boolean doRender) {
        this.itemTransforms.computeIfAbsent(render, k -> new ItemTransform()).set(stack, doRender);
    }

    private void clear() {
        this.parts = Collections.emptyList();
        this.resolved = null;
        this.cubes = null;
        this.cubeMap = null;
        this.textures = null;
        this.rootRenderingCubes = null;
        this.animations = null;
        this.scale = null;
        this.itemTransforms = null;
    }

    public SafetyException.BlockReason getBlockReason() {
        if (this.error instanceof SafetyException) {
            return ((SafetyException)this.error).getBlockReason();
        }
        return null;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable ex) {
        this.cleanup();
        if (ex instanceof ExecutionException || ex instanceof UncheckedExecutionException) {
            ex = ex.getCause();
        }
        this.resolveState = ex instanceof SafetyException ? ModelLoadingState.SAFETY_BLOCKED : ModelLoadingState.ERRORRED;
        this.error = ex;
        if (!(ex instanceof IOException) && !(ex instanceof SafetyException)) {
            Log.error("Failed to load model", ex);
        }
        this.clear();
    }

    public boolean isHideHeadIfSkull() {
        return this.hideHeadIfSkull;
    }

    public boolean isRemoveArmorOffset() {
        return this.removeArmorOffset;
    }

    public FormatText getStatus() {
        switch (this.getResolveState()) {
            case ERRORRED: {
                if (this.getError() instanceof LocalizedException) {
                    return new FormatText("label.cpm.errorLoadingModel", ((LocalizedException)((Object)this.getError())).getLocalizedText());
                }
                return new FormatText("label.cpm.errorLoadingModel", this.getError().toString());
            }
            case NEW: 
            case RESOLVING: {
                return new FormatText("label.cpm.loading", new Object[0]);
            }
            case SAFETY_BLOCKED: {
                if (this.getBlockReason() == SafetyException.BlockReason.BLOCK_LIST) {
                    return null;
                }
                return new FormatText("label.cpm.safetyBlocked", new Object[0]);
            }
        }
        return null;
    }

    public void addCubes(Collection<RenderedCube> cubes) {
        this.cubes.addAll(cubes);
    }

    public static enum ModelLoadingState {
        NEW,
        RESOLVING,
        LOADED,
        SAFETY_BLOCKED,
        ERRORRED,
        CLEANED_UP;

    }
}

