/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.math.MathHelper;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.network.ServerCaps;
import java.util.List;
import java.util.Set;

public class AnimationTrigger {
    public final Set<IPose> onPoses;
    public final List<IAnimation> animations;
    public final boolean looping;
    public final boolean mustFinish;
    public final VanillaPose valuePose;

    public AnimationTrigger(Set<IPose> onPoses, VanillaPose valuePose, List<IAnimation> animations, boolean looping, boolean mustFinish) {
        this.onPoses = onPoses;
        this.valuePose = valuePose;
        this.animations = animations;
        this.looping = looping;
        this.mustFinish = mustFinish;
    }

    public long getTime(AnimationState state, long time) {
        return this.valuePose != null ? this.valuePose.getTime(state, time) : time;
    }

    public boolean canPlay(Player<?> pl, AnimationEngine.AnimationMode mode) {
        return true;
    }

    public static class ValueTrigger
    extends AnimationTrigger {
        private final int id;
        private boolean interpolate;

        public ValueTrigger(Set<IPose> onPoses, List<IAnimation> animations, int id, boolean interpolate) {
            super(onPoses, null, animations, true, false);
            this.id = id;
            this.interpolate = interpolate;
        }

        @Override
        public long getTime(AnimationState state, long animTime) {
            if (state.gestureData != null && state.gestureData.length > this.id) {
                float val = (float)Byte.toUnsignedInt(state.gestureData[this.id]) / 256.0f;
                long time = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
                if (this.interpolate && state.prevGestureData != null && state.prevGestureData.length == state.gestureData.length && state.lastGestureReceiveTime + 50L >= time) {
                    float prev = (float)Byte.toUnsignedInt(state.prevGestureData[this.id]) / 256.0f;
                    val = MathHelper.lerp((float)(time - state.lastGestureReceiveTime) / 50.0f, prev, val);
                }
                return (long)(val * 1000.0f);
            }
            return 0L;
        }
    }

    public static class GestureTrigger
    extends AnimationTrigger {
        private final int value;
        private final int gid;

        public GestureTrigger(Set<IPose> onPoses, List<IAnimation> animations, int value, int gid, boolean looping, boolean mustFinish) {
            super(onPoses, null, animations, looping, mustFinish);
            this.value = value;
            this.gid = gid;
        }

        @Override
        public boolean canPlay(Player<?> pl, AnimationEngine.AnimationMode mode) {
            if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
                if (pl.animState.gestureData != null && pl.animState.gestureData.length > 1) {
                    byte v = pl.animState.gestureData[1];
                    return v == this.value;
                }
            } else if (this.gid != -1) {
                return pl.animState.encodedState == this.gid;
            }
            return false;
        }
    }

    public static class LayerTrigger
    extends AnimationTrigger {
        private final int id;
        private final int mask;
        private final boolean bitmask;

        public LayerTrigger(Set<IPose> onPoses, List<IAnimation> animations, int id, int mask, boolean bitmask, boolean mustFinish) {
            super(onPoses, null, animations, true, mustFinish);
            this.id = id;
            this.mask = mask;
            this.bitmask = bitmask;
        }

        @Override
        public boolean canPlay(Player<?> pl, AnimationEngine.AnimationMode mode) {
            if (pl.animState.gestureData != null && pl.animState.gestureData.length > this.id) {
                byte v = pl.animState.gestureData[this.id];
                if (this.bitmask) {
                    return (v & this.mask) == this.mask;
                }
                return v == this.mask;
            }
            return false;
        }
    }
}

