/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.bukkit;

import com.tom.cpm.bukkit.AttributeScaler;
import com.tom.cpm.bukkit.CPMBukkitPlugin;
import com.tom.cpm.bukkit.text.BukkitText;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.io.FastByteArrayInputStream;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitRunnable;

public class Network
implements PluginMessageListener,
Listener {
    public static final String PLAYER_DATA = "cpm_net:data";
    private final CPMBukkitPlugin plugin;
    public NetHandler<String, Player, Meta> netHandler;

    public Network(CPMBukkitPlugin plugin) {
        this.plugin = plugin;
        try {
            this.netHandler = new NetHandler((k, v) -> k + ":" + v);
            this.netHandler.setSendPacketDirect((pl, pck, dt) -> ((Meta)pl).owner.sendPluginMessage((Plugin)plugin, pck, dt), this::sendToAllTrackingAndSelf);
            this.netHandler.setGetPlayerUUID(OfflinePlayer::getUniqueId);
            this.netHandler.setFindTracking((p, c) -> Network.getPlayersWithin(p, 64, c));
            this.netHandler.setSendChat((pl, msg) -> ((BukkitText)msg.remap()).sendTo((CommandSender)pl));
            this.netHandler.setExecutor(() -> Runnable::run);
            this.netHandler.setGetNet(this::getMetadata);
            this.netHandler.setGetPlayer(n -> ((Meta)n).owner);
            this.netHandler.setGetPlayerId(Entity::getEntityId);
            this.netHandler.setGetOnlinePlayers(Bukkit::getOnlinePlayers);
            this.netHandler.setKickPlayer((p, m) -> p.kickPlayer(m.remap().toString()));
            boolean hasAttributes = false;
            try {
                Attribute.values();
                hasAttributes = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            boolean fhasAttributes = hasAttributes;
            this.netHandler.setGetPlayerAnimGetters((t, u) -> {
                u.updated = true;
                u.creativeFlying = t.isFlying();
                u.falling = t.getFallDistance();
                u.health = fhasAttributes ? (float)(t.getHealth() / t.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) : (float)(t.getHealth() / t.getMaxHealth());
                u.air = Math.max((float)t.getRemainingAir() / (float)t.getMaximumAir(), 0.0f);
                u.hunger = (float)t.getFoodLevel() / 20.0f;
                u.inMenu = t.getOpenInventory() != null;
            });
            if (fhasAttributes) {
                this.netHandler.addScaler(new AttributeScaler());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void register() {
        this.netHandler.registerOut(c -> Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, c));
        this.netHandler.registerIn(c -> Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, c, (PluginMessageListener)this));
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        new BukkitRunnable(){

            public void run() {
                Network.this.netHandler.tick();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public static void getPlayersWithin(Player player, int distance, Consumer<Player> cons) {
        int d2 = distance * distance;
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p.getWorld() != player.getWorld() || !(p.getLocation().distanceSquared(player.getLocation()) <= (double)d2)) continue;
            cons.accept(p);
        }
    }

    private void sendToAllTrackingAndSelf(Player player, String packet, byte[] data) {
        Network.getPlayersWithin(player, 64, pl -> {
            if (this.getMetadata((Player)pl).cpm$hasMod()) {
                pl.sendPluginMessage((Plugin)this.plugin, packet, data);
            }
        });
    }

    public void onPluginMessageReceived(String name, Player player, byte[] packet) {
        this.netHandler.receiveServer(name, new FastByteArrayInputStream(packet), this.getMetadata(player));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent evt) {
        try {
            Method addChn = evt.getPlayer().getClass().getDeclaredMethod("addChannel", String.class);
            this.netHandler.registerOut(c -> addChn.invoke((Object)evt.getPlayer(), c));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        evt.getPlayer().setMetadata(PLAYER_DATA, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)new Meta(evt.getPlayer())));
        this.netHandler.onJoin(evt.getPlayer());
    }

    @EventHandler
    public void onPlayerStatisticIncrement(PlayerStatisticIncrementEvent event) {
        if (event.getStatistic() == Statistic.JUMP) {
            this.netHandler.onJump(event.getPlayer());
        }
    }

    public Meta getMetadata(Player player) {
        List m = player.getMetadata(PLAYER_DATA);
        if (m != null) {
            for (MetadataValue mv : m) {
                if (mv.getOwningPlugin() != this.plugin || !(mv instanceof FixedMetadataValue)) continue;
                return (Meta)((FixedMetadataValue)mv).value();
            }
        }
        Log.info("Created player data for player");
        Meta mt = new Meta(player);
        mt.cpm$setEncodedModelData(new PlayerData());
        player.setMetadata(PLAYER_DATA, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)mt));
        return mt;
    }

    public void onTrackingStart(Player to, Player player) {
        this.netHandler.sendPlayerData(player, to);
    }

    public static class Meta
    implements NetH.ServerNetH {
        private final Player owner;
        private boolean hasMod;
        private PlayerData data;
        public List<Player> trackingPlayers = new ArrayList<Player>();

        public Meta(Player owner) {
            this.owner = owner;
        }

        @Override
        public boolean cpm$hasMod() {
            return this.hasMod;
        }

        @Override
        public void cpm$setHasMod(boolean v) {
            this.hasMod = v;
        }

        @Override
        public PlayerData cpm$getEncodedModelData() {
            return this.data;
        }

        @Override
        public void cpm$setEncodedModelData(PlayerData data) {
            this.data = data;
        }
    }
}

