/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.bukkit;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tom.cpl.command.BrigadierCommandHandler;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.TextRemapper;
import com.tom.cpm.bukkit.CPMBukkitPlugin;
import com.tom.cpm.bukkit.CommandHandler;
import com.tom.cpm.bukkit.text.BukkitText;
import com.tom.cpm.bukkit.text.ComponentText;
import dev.jorel.commandapi.Brigadier;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandAPIPlatform;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandAPICommands
extends BrigadierCommandHandler<Object>
implements CommandHandler {
    private CPMBukkitPlugin pl;

    private CommandAPICommands(CPMBukkitPlugin pl) {
        super(Brigadier.getCommandDispatcher(), false);
        this.pl = pl;
    }

    public static CommandAPICommands init(CPMBukkitPlugin pl) {
        for (String commandName : pl.getDescription().getCommands().keySet()) {
            CommandAPIBukkit.unregister((String)commandName, (boolean)true, (boolean)true);
        }
        return new CommandAPICommands(pl);
    }

    @Override
    public String toStringPlayer(Object pl) {
        return ((Player)pl).getDisplayName();
    }

    @Override
    public void sendSuccess(Object sender, IText text) {
        ((BukkitText)text.remap()).sendTo((CommandSender)CommandAPICommands.getCommandSender(sender).getSource());
    }

    @Override
    protected boolean hasOPPermission(Object source) {
        return CommandAPICommands.getCommandSender(source).isOp();
    }

    @Override
    protected ArgumentType<?> player() {
        return Brigadier.fromArgument((AbstractArgument)new EntitySelectorArgument.OnePlayer("a")).getType();
    }

    @Override
    protected Object getPlayer(CommandContext<Object> ctx, String id) throws CommandSyntaxException {
        return Brigadier.parseArguments(ctx, Arrays.asList(new EntitySelectorArgument.OnePlayer(id)))[0];
    }

    private static AbstractCommandSender<? extends CommandSender> getCommandSender(Object src) {
        CommandAPIPlatform platform = CommandAPIHandler.getInstance().getPlatform();
        return platform.getCommandSenderFromCommandSource(src);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }

    public TextRemapper<ComponentText> remapper() {
        return ComponentText.make(BukkitText.simple(this.pl), Text::new);
    }

    public static class Text
    extends ComponentText
    implements Message {
        public Text(BukkitText.Simple fallback, BaseComponent comp) {
            super(fallback, comp);
        }

        public String getString() {
            return this.toString();
        }
    }
}

