/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.bukkit;

import com.tom.cpl.block.BiomeHandler;
import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.block.entity.EntityTypeHandler;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.item.ItemStackHandler;
import com.tom.cpl.text.TextRemapper;
import com.tom.cpl.util.ILogger;
import com.tom.cpm.api.CPMApiManager;
import com.tom.cpm.api.CPMPluginRegistry;
import com.tom.cpm.api.ICPMPlugin;
import com.tom.cpm.bukkit.BukkitLogger;
import com.tom.cpm.bukkit.CommandAPICommands;
import com.tom.cpm.bukkit.CommandHandler;
import com.tom.cpm.bukkit.Commands;
import com.tom.cpm.bukkit.I18n;
import com.tom.cpm.bukkit.Network;
import com.tom.cpm.bukkit.PlayerTracker;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.MinecraftServerAccess;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.network.NetHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class CPMBukkitPlugin
extends JavaPlugin {
    public ModConfigFile config;
    private Network net;
    public I18n i18n;
    private BukkitLogger log;
    private CommandHandler cmd;
    private CPMApiManager api;
    public TextRemapper<String> stringMapper;

    public void onDisable() {
        super.onDisable();
        MinecraftObjectHolder.setCommonObject(null);
        MinecraftObjectHolder.setServerObject(null);
        this.config.save();
    }

    public void onEnable() {
        super.onEnable();
        this.getDataFolder().mkdirs();
        this.log = new BukkitLogger(this.getLogger());
        this.config = new ModConfigFile(new File(this.getDataFolder(), "cpm.json"));
        File tr = new File(this.getDataFolder(), "cpm.lang");
        if (tr.exists()) {
            try {
                this.i18n = I18n.loadLocaleData(new FileInputStream(tr));
            }
            catch (IOException e) {
                this.log.warn("Failed to load localization from cpm.lang", e);
            }
        }
        if (this.i18n == null) {
            try {
                this.i18n = I18n.loadLocaleData(CPMBukkitPlugin.class.getResourceAsStream("/assets/cpm/lang/en_us.lang"));
            }
            catch (IOException e) {
                this.log.error("Failed to load localization from builtin lang file", e);
                this.i18n = new I18n(){

                    @Override
                    public String format(String translateKey, Object ... parameters) {
                        return "Server failed to load builtin localization. This is a BUG, please report it to the server owner.";
                    }
                };
            }
        }
        this.api = new CPMApiManager();
        this.api.buildCommon().player(Player.class).init();
        this.getServer().getServicesManager().register(CPMPluginRegistry.class, (Object)new CPMPluginRegistry(){

            @Override
            public void register(ICPMPlugin plugin) {
                CPMBukkitPlugin.this.api.register(plugin);
                CPMBukkitPlugin.this.api.commonApi().callInit(plugin);
            }
        }, (Plugin)this, ServicePriority.Normal);
        this.stringMapper = TextRemapper.stringMapper(this.i18n::format);
        try {
            this.cmd = CommandAPICommands.init(this);
        }
        catch (Throwable e) {
            this.cmd = new Commands.FallbackCommandHandler(this);
            this.log.warn("Command API not found, using fallback command system.");
        }
        MinecraftObjectHolder.setCommonObject(new MinecraftCommonAccess(){

            @Override
            public ModConfigFile getConfig() {
                return CPMBukkitPlugin.this.config;
            }

            @Override
            public ILogger getLogger() {
                return CPMBukkitPlugin.this.log;
            }

            @Override
            public EnumSet<PlatformFeature> getSupportedFeatures() {
                return EnumSet.noneOf(PlatformFeature.class);
            }

            @Override
            public String getPlatformVersionString() {
                return "Bukkit (" + CPMBukkitPlugin.this.getServer().getVersion() + "/" + CPMBukkitPlugin.this.getServer().getBukkitVersion() + ") " + CPMBukkitPlugin.this.getDescription().getVersion();
            }

            @Override
            public TextRemapper<?> getTextRemapper() {
                return CPMBukkitPlugin.this.cmd.remapper();
            }

            @Override
            public CPMApiManager getApi() {
                return CPMBukkitPlugin.this.api;
            }

            @Override
            public String getMCVersion() {
                return "bukkit";
            }

            @Override
            public String getMCBrand() {
                return "Bukkit (" + CPMBukkitPlugin.this.getServer().getVersion() + "/" + CPMBukkitPlugin.this.getServer().getBukkitVersion() + ")";
            }

            @Override
            public String getModVersion() {
                return CPMBukkitPlugin.this.getDescription().getVersion();
            }

            @Override
            public ItemStackHandler<?> getItemStackHandler() {
                return null;
            }

            @Override
            public BlockStateHandler<?> getBlockStateHandler() {
                return null;
            }

            @Override
            public EntityTypeHandler<?> getEntityTypeHandler() {
                return null;
            }
        });
        MinecraftObjectHolder.setServerObject(new MinecraftServerAccess(){

            @Override
            public ModConfigFile getConfig() {
                return CPMBukkitPlugin.this.config;
            }

            @Override
            public NetHandler<?, ?, ?> getNetHandler() {
                return ((CPMBukkitPlugin)CPMBukkitPlugin.this).net.netHandler;
            }

            @Override
            public BiomeHandler<?> getBiomeHandler() {
                return null;
            }
        });
        this.net = new Network(this);
        this.net.register();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new PlayerTracker(this.net), 0L, 20L);
        this.log.info("Customizable Player Models Initialized");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.cmd.onCommand(sender, command, label, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return this.cmd.onTabComplete(sender, command, alias, args);
    }
}

