/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.MinecraftCommonAccess;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class ModConfigFile
extends ConfigEntry {
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();
    private File cfgFile;
    private boolean changed = false;

    public ModConfigFile(File file) {
        this(file, null);
    }

    public ModConfigFile(File file, File def) {
        this.cfgFile = file;
        this.changeListener = () -> {
            this.changed = true;
        };
        if (this.cfgFile.exists()) {
            try (FileReader rd2 = new FileReader(this.cfgFile);){
                this.data = (Map)gson.fromJson((Reader)rd2, Object.class);
            }
            catch (Exception rd2) {}
        } else if (def != null && def.exists()) {
            try (FileReader rd = new FileReader(def);){
                this.data = (Map)gson.fromJson((Reader)rd, Object.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data == null) {
            this.data = new TreeMap();
            this.changed = true;
        }
        if (def != null && !this.data.containsKey("__COMMENT1")) {
            this.data.put("__COMMENT1", "To apply this configuration to all newly generated worlds");
            this.data.put("__COMMENT2", "please place this configuration file into your config directory");
            this.data.put("__COMMENT3", "with the following name: " + def.getName());
            this.changed = true;
            this.save();
        }
    }

    public static ModConfigFile createServer(File file) {
        File cfgDir = MinecraftCommonAccess.get().getConfig().cfgFile.getParentFile();
        return new ModConfigFile(file, new File(cfgDir, file.getName().substring(0, file.getName().length() - 5) + "-server-default.json"));
    }

    public void save() {
        if (this.changed) {
            try (FileWriter wr = new FileWriter(this.cfgFile);){
                gson.toJson((Object)this.data, Object.class, (Appendable)wr);
                this.changed = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ConfigEntryTemp createTemp() {
        return new ConfigEntryTemp(this.data);
    }

    public class ConfigEntryTemp
    extends ConfigEntry {
        private ConfigEntry ent;
        private boolean dirty;

        public ConfigEntryTemp(Map<String, Object> map) {
            this.changeListener = this::markDirty;
            this.data = new HashMap<String, Object>(map);
        }

        public void saveConfig() {
            ModConfigFile.this.data = this.data;
            ModConfigFile.this.changed = true;
            ModConfigFile.this.entries.clear();
            ModConfigFile.this.lists.clear();
            ModConfigFile.this.save();
            this.dirty = false;
        }

        @Override
        public ConfigEntry getEntry(String name) {
            return this.entries.computeIfAbsent(name, k -> new ConfigEntry(this.mapGet(name, HashMap::new, HashMap::new), this.changeListener));
        }

        @Override
        public ConfigEntry.ConfigEntryList getEntryList(String name) {
            return this.lists.computeIfAbsent(name, k -> new ConfigEntry.ConfigEntryList(this.mapGet(name, ArrayList::new, ArrayList::new), this.changeListener));
        }

        private <T> T mapGet(String name, Supplier<T> newV, UnaryOperator<T> copy) {
            return (T)this.data.compute(name, (k, v) -> v == null ? newV.get() : copy.apply(v));
        }

        public void markDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }
    }
}

