/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigEntry {
    protected Map<String, ConfigEntry> entries = new HashMap<String, ConfigEntry>();
    protected Map<String, ConfigEntryList> lists = new HashMap<String, ConfigEntryList>();
    protected Map<String, Object> data;
    protected Runnable changeListener;

    protected ConfigEntry() {
    }

    public ConfigEntry(Map<String, Object> data, Runnable changeListener) {
        this.data = data;
        this.changeListener = changeListener;
    }

    public String getString(String name, String def) {
        try {
            return (String)this.data.getOrDefault(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public String getSetString(String name, String def) {
        try {
            return this.getSet(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public void setString(String name, String value) {
        this.data.put(name, value);
        this.changeListener.run();
    }

    public void clearValue(String name) {
        this.data.remove(name);
        this.entries.remove(name);
        this.lists.remove(name);
        this.changeListener.run();
    }

    public int getInt(String name, int def) {
        try {
            return ((Number)this.data.getOrDefault(name, def)).intValue();
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public int getSetInt(String name, int def) {
        try {
            return ((Number)this.getSet(name, def)).intValue();
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public void setInt(String name, int value) {
        this.data.put(name, value);
        this.changeListener.run();
    }

    public boolean getBoolean(String name, boolean def) {
        try {
            return (Boolean)this.data.getOrDefault(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public boolean getSetBoolean(String name, boolean def) {
        try {
            return this.getSet(name, def);
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    private <T> T getSet(String name, T def) {
        Object v = this.data.get(name);
        if (v == null) {
            v = def;
            this.data.put(name, def);
            this.changeListener.run();
        }
        return (T)v;
    }

    public void setBoolean(String name, boolean value) {
        this.data.put(name, value);
        this.changeListener.run();
    }

    public ConfigEntry getEntry(String name) {
        return this.entries.computeIfAbsent(name, k -> new ConfigEntry((Map)this.data.computeIfAbsent(name, k2 -> new HashMap()), this.changeListener));
    }

    public ConfigEntryList getEntryList(String name) {
        return this.lists.computeIfAbsent(name, k -> new ConfigEntryList((List)this.data.computeIfAbsent(name, k2 -> new ArrayList()), this.changeListener));
    }

    public boolean hasEntry(String name) {
        return this.data.containsKey(name);
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public float getFloat(String name, float def) {
        try {
            return ((Number)this.data.getOrDefault(name, Float.valueOf(def))).floatValue();
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public float getSetFloat(String name, float def) {
        try {
            return ((Number)this.getSet(name, Float.valueOf(def))).floatValue();
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public void setFloat(String name, float value) {
        this.data.put(name, Float.valueOf(value));
        this.changeListener.run();
    }

    public void clear() {
        this.data.clear();
        this.entries.clear();
        this.lists.clear();
        this.changeListener.run();
    }

    public static class ConfigEntryList {
        protected List<Object> data;
        protected Runnable changeListener;

        public ConfigEntryList(List<Object> data, Runnable changeListener) {
            this.data = data;
            this.changeListener = changeListener;
        }

        public int size() {
            return this.data.size();
        }

        public boolean add(Object e) {
            boolean s = this.data.add(e);
            if (s) {
                this.changeListener.run();
            }
            return s;
        }

        public void clear() {
            this.data.clear();
            this.changeListener.run();
        }

        public Object get(int index) {
            return this.data.get(index);
        }

        public boolean contains(Object o) {
            return this.data.contains(o);
        }
    }
}

