/*
 * Decompiled with CFR 0.152.
 */
package dev.ethancao.antixray.tracking;

import dev.ethancao.antixray.tracking.MiningStats;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerDataManager {
    private final Map<UUID, MiningStats> playerStats = new HashMap<UUID, MiningStats>();

    public MiningStats getOrCreateStats(UUID playerUuid, String playerName) {
        return this.playerStats.computeIfAbsent(playerUuid, uuid -> new MiningStats((UUID)uuid, playerName));
    }

    public MiningStats getStats(UUID playerUuid) {
        return this.playerStats.get(playerUuid);
    }

    public boolean hasStats(UUID playerUuid) {
        return this.playerStats.containsKey(playerUuid);
    }

    public void resetStats(UUID playerUuid) {
        MiningStats stats = this.playerStats.get(playerUuid);
        if (stats != null) {
            stats.reset();
        }
    }

    public void removePlayer(UUID playerUuid) {
        this.playerStats.remove(playerUuid);
    }

    public int getTrackedPlayerCount() {
        return this.playerStats.size();
    }

    public void clearAll() {
        this.playerStats.clear();
    }
}

