/*
 * Decompiled with CFR 0.152.
 */
package dev.ethancao.antixray.tracking;

import java.util.UUID;

public class MiningStats {
    private final UUID playerUuid;
    private final String playerName;
    private int diamondsMined = 0;
    private int ironMined = 0;
    private int goldMined = 0;
    private int emeraldsMined = 0;
    private int lapisMined = 0;
    private int redstoneMineds = 0;
    private int coalMined = 0;
    private int stoneMined = 0;
    private int deepslateStoned = 0;
    private long firstMineTime;
    private long lastMineTime;
    private int suspicionScore = 0;
    private int manualFlags = 0;

    public MiningStats(UUID playerUuid, String playerName) {
        this.playerUuid = playerUuid;
        this.playerName = playerName;
        this.firstMineTime = System.currentTimeMillis();
        this.lastMineTime = System.currentTimeMillis();
    }

    public void incrementDiamonds() {
        ++this.diamondsMined;
        this.updateLastMineTime();
    }

    public void incrementIron() {
        ++this.ironMined;
        this.updateLastMineTime();
    }

    public void incrementGold() {
        ++this.goldMined;
        this.updateLastMineTime();
    }

    public void incrementEmeralds() {
        ++this.emeraldsMined;
        this.updateLastMineTime();
    }

    public void incrementLapis() {
        ++this.lapisMined;
        this.updateLastMineTime();
    }

    public void incrementRedstone() {
        ++this.redstoneMineds;
        this.updateLastMineTime();
    }

    public void incrementCoal() {
        ++this.coalMined;
        this.updateLastMineTime();
    }

    public void incrementStone() {
        ++this.stoneMined;
        this.updateLastMineTime();
    }

    public void incrementDeepslate() {
        ++this.deepslateStoned;
        this.updateLastMineTime();
    }

    private void updateLastMineTime() {
        this.lastMineTime = System.currentTimeMillis();
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public int getDiamondsMined() {
        return this.diamondsMined;
    }

    public int getIronMined() {
        return this.ironMined;
    }

    public int getGoldMined() {
        return this.goldMined;
    }

    public int getEmeraldsMined() {
        return this.emeraldsMined;
    }

    public int getLapisMined() {
        return this.lapisMined;
    }

    public int getRedstoneMined() {
        return this.redstoneMineds;
    }

    public int getCoalMined() {
        return this.coalMined;
    }

    public int getStoneMined() {
        return this.stoneMined;
    }

    public int getDeepslateMined() {
        return this.deepslateStoned;
    }

    public int getTotalOresMined() {
        return this.diamondsMined + this.ironMined + this.goldMined + this.emeraldsMined + this.lapisMined + this.redstoneMineds + this.coalMined;
    }

    public int getTotalStoneBlocks() {
        return this.stoneMined + this.deepslateStoned;
    }

    public int getSuspicionScore() {
        return this.suspicionScore;
    }

    public void setSuspicionScore(int score) {
        this.suspicionScore = score;
    }

    public void addSuspicionPoints(int points) {
        this.suspicionScore += points;
    }

    public int getManualFlags() {
        return this.manualFlags;
    }

    public void addManualFlag() {
        ++this.manualFlags;
    }

    public long getFirstMineTime() {
        return this.firstMineTime;
    }

    public long getLastMineTime() {
        return this.lastMineTime;
    }

    public double getOreToStoneRatio() {
        int totalStone = this.getTotalStoneBlocks();
        if (totalStone == 0) {
            return 0.0;
        }
        return (double)this.getTotalOresMined() / (double)totalStone;
    }

    public double getDiamondToStoneRatio() {
        int totalStone = this.getTotalStoneBlocks();
        if (totalStone == 0) {
            return 0.0;
        }
        return (double)this.diamondsMined / (double)totalStone;
    }

    public void reset() {
        this.diamondsMined = 0;
        this.ironMined = 0;
        this.goldMined = 0;
        this.emeraldsMined = 0;
        this.lapisMined = 0;
        this.redstoneMineds = 0;
        this.coalMined = 0;
        this.stoneMined = 0;
        this.deepslateStoned = 0;
        this.suspicionScore = 0;
        this.manualFlags = 0;
        this.firstMineTime = System.currentTimeMillis();
        this.lastMineTime = System.currentTimeMillis();
    }
}

