/*
 * Decompiled with CFR 0.152.
 */
package dev.ethancao.antixray.logging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.ethancao.antixray.logging.XrayEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.logging.Logger;

public class JsonLogger {
    private final File logFile;
    private final Gson gson;
    private final Logger pluginLogger;
    private final DateTimeFormatter isoFormatter;

    public JsonLogger(File dataFolder, Logger logger) {
        this.pluginLogger = logger;
        File logsDir = new File(dataFolder, "logs");
        if (!logsDir.exists()) {
            if (logsDir.mkdirs()) {
                this.pluginLogger.info("Created logs directory: " + logsDir.getAbsolutePath());
            } else {
                this.pluginLogger.warning("Failed to create logs directory!");
            }
        }
        this.logFile = new File(logsDir, "antixray.jsonl");
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
        this.isoFormatter = DateTimeFormatter.ISO_INSTANT;
        this.pluginLogger.info("JSON logger initialized: " + this.logFile.getAbsolutePath());
    }

    public void logEvent(XrayEvent event) {
        try (FileWriter fw = new FileWriter(this.logFile, true);
             PrintWriter pw = new PrintWriter(fw);){
            String json = this.gson.toJson((Object)event);
            pw.println(json);
        }
        catch (IOException e) {
            this.pluginLogger.severe("Failed to write to log file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getCurrentTimestamp() {
        return this.isoFormatter.format(Instant.now().atOffset(ZoneOffset.UTC));
    }

    public String getLogFilePath() {
        return this.logFile.getAbsolutePath();
    }

    public boolean isReady() {
        return this.logFile.getParentFile().exists() && this.logFile.getParentFile().canWrite();
    }
}

